/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_17_R1.entity.fake;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.nms.v1_17_R1.NMSUtils;
import com.ticxo.modelengine.nms.v1_17_R1.entity.fake.DataAccessors;
import com.ticxo.modelengine.nms.v1_17_R1.network.NetworkUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Vector3f;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class FakeArmorStand {
    private final int entityId;
    private final UUID uuid;
    private final Vector location = new Vector();
    private byte lastYaw;
    private Vector lastOffset;
    private boolean sendCancelPacket;
    private boolean isInvisible = false;
    private boolean isGlowing = false;
    private final DataWatcher.Item<Byte> commonDataItem;
    private final DataWatcher.Item<Integer> airTickDataItem;
    private final DataWatcher.Item<Optional<IChatBaseComponent>> customNameDataItem;
    private final DataWatcher.Item<Boolean> customNameVisibleDataItem;
    private boolean isCustomNameVisible = false;
    private boolean isSmall = false;
    private final DataWatcher.Item<Byte> standDataItem;
    private Vector3f rotation;
    private DataWatcher.Item<Vector3f> rotationDataItem;
    private FakeEntity.DisplaySlot display = FakeEntity.DisplaySlot.ZERO;

    public FakeArmorStand(double x, double y, double z) {
        this.entityId = ModelEngineAPI.getEntityHandler().getEntityCounter().incrementAndGet();
        this.uuid = UUID.randomUUID();
        this.location.setX(x).setY(y).setZ(z);
        this.commonDataItem = new DataWatcher.Item(DataAccessors.COMMON_DATA, (Object)0);
        this.airTickDataItem = new DataWatcher.Item(DataAccessors.AIR_TICK, (Object)Integer.MAX_VALUE);
        this.customNameDataItem = new DataWatcher.Item(DataAccessors.CUSTOM_NAME, Optional.empty());
        this.customNameVisibleDataItem = new DataWatcher.Item(DataAccessors.CUSTOM_NAME_VISIBLE, (Object)false);
        this.standDataItem = new DataWatcher.Item(DataAccessors.STAND_DATA, (Object)16);
        this.rotationDataItem = new DataWatcher.Item(DataAccessors.HEAD_POSE, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public PacketPlayOutSpawnEntity spawn() {
        return this.spawn(0.0f);
    }

    public PacketPlayOutSpawnEntity spawn(float yaw) {
        byte byteYaw = TMath.rotToByte(yaw);
        this.updateOffset(byteYaw);
        PacketDataSerializer spawn = NetworkUtils.createByteBuf();
        spawn.d(this.entityId);
        spawn.a(this.uuid);
        spawn.d(IRegistry.Y.getId((Object)EntityTypes.c));
        spawn.writeDouble(this.location.getX() + this.lastOffset.getX());
        spawn.writeDouble(this.location.getY() + this.lastOffset.getY());
        spawn.writeDouble(this.location.getZ() + this.lastOffset.getZ());
        spawn.writeByte(0);
        spawn.writeByte((int)byteYaw);
        spawn.writeInt(0);
        spawn.writeShort(0);
        spawn.writeShort(0);
        spawn.writeShort(0);
        return new PacketPlayOutSpawnEntity(spawn);
    }

    public PacketPlayOutEntityMetadata updateMeta(boolean isAll) {
        List<DataWatcher.Item<?>> dirty = this.packData(isAll);
        if (dirty.isEmpty()) {
            return null;
        }
        PacketDataSerializer meta = NetworkUtils.createByteBuf();
        meta.d(this.entityId);
        DataWatcher.a(dirty, (PacketDataSerializer)meta);
        return new PacketPlayOutEntityMetadata(meta);
    }

    public Packet<PacketListenerPlayOut> updatePosition(Vector vector) {
        return this.updatePosition(0.0f, vector);
    }

    public Packet<PacketListenerPlayOut> updatePosition(float yaw, Vector vector) {
        byte byteYaw = TMath.rotToByte(yaw);
        if (TMath.isSimilar(this.location, vector)) {
            if (this.lastYaw == byteYaw) {
                return null;
            }
            Vector tempOffset = this.lastOffset.clone();
            this.updateOffset(byteYaw);
            if (TMath.isSimilar(tempOffset, this.lastOffset)) {
                return this.createYawPacket(byteYaw);
            }
            return this.createTeleportPacket(this.location.getX() + this.lastOffset.getX(), this.location.getY() + this.lastOffset.getY(), this.location.getZ() + this.lastOffset.getZ(), this.lastYaw);
        }
        if (this.lastYaw != byteYaw) {
            this.updateOffset(byteYaw);
        }
        this.location.zero().add(vector);
        return this.createTeleportPacket(this.location.getX() + this.lastOffset.getX(), this.location.getY() + this.lastOffset.getY(), this.location.getZ() + this.lastOffset.getZ(), byteYaw);
    }

    public Packet<PacketListenerPlayOut> updatePositionCalibrated(Vector vector) {
        return this.updatePositionCalibrated(0.0f, vector);
    }

    public Packet<PacketListenerPlayOut> updatePositionCalibrated(float yaw, Vector vector) {
        byte byteYaw = TMath.rotToByte(yaw);
        if (TMath.isSimilar(this.location, vector)) {
            if (this.lastYaw == byteYaw) {
                if (!this.sendCancelPacket) {
                    return null;
                }
                this.sendCancelPacket = false;
                return this.createTeleportPacket(this.location.getX() + this.lastOffset.getX(), this.location.getY() + this.lastOffset.getY(), this.location.getZ() + this.lastOffset.getZ(), this.lastYaw);
            }
            Vector tempOffset = this.lastOffset.clone();
            this.updateOffset(byteYaw);
            if (TMath.isSimilar(tempOffset, this.lastOffset)) {
                return this.createYawPacket(byteYaw);
            }
            this.sendCancelPacket = true;
            tempOffset = TMath.lerp(tempOffset, this.lastOffset, 3.0);
            return this.createTeleportPacket(this.location.getX() + tempOffset.getX(), this.location.getY() + tempOffset.getY(), this.location.getZ() + tempOffset.getZ(), this.lastYaw);
        }
        Vector prevLoc = new Vector(this.location.getX() + this.lastOffset.getX(), this.location.getY() + this.lastOffset.getY(), this.location.getZ() + this.lastOffset.getZ());
        if (this.lastYaw != byteYaw) {
            this.updateOffset(byteYaw);
        }
        this.location.zero().add(vector);
        Vector currLoc = new Vector(this.location.getX() + this.lastOffset.getX(), this.location.getY() + this.lastOffset.getY(), this.location.getZ() + this.lastOffset.getZ());
        this.sendCancelPacket = true;
        currLoc = TMath.lerp(prevLoc, currLoc, 3.0);
        return this.createTeleportPacket(currLoc.getX(), currLoc.getY(), currLoc.getZ(), byteYaw);
    }

    private PacketPlayOutEntityTeleport createTeleportPacket(double x, double y, double z, byte yaw) {
        PacketDataSerializer pos = NetworkUtils.createByteBuf();
        pos.d(this.entityId);
        pos.writeDouble(x);
        pos.writeDouble(y);
        pos.writeDouble(z);
        pos.writeByte((int)yaw);
        pos.writeByte(0);
        pos.writeBoolean(false);
        return new PacketPlayOutEntityTeleport(pos);
    }

    public PacketPlayOutEntity.PacketPlayOutEntityLook updateYaw(float yaw, boolean force) {
        byte nYaw = TMath.rotToByte(yaw);
        if (!force && this.lastYaw == nYaw) {
            return null;
        }
        this.lastYaw = nYaw;
        return this.createYawPacket(nYaw);
    }

    private PacketPlayOutEntity.PacketPlayOutEntityLook createYawPacket(byte yaw) {
        PacketDataSerializer rot = NetworkUtils.createByteBuf();
        rot.d(this.entityId);
        rot.writeByte((int)yaw);
        rot.writeByte(0);
        rot.writeBoolean(false);
        return PacketPlayOutEntity.PacketPlayOutEntityLook.b((PacketDataSerializer)rot);
    }

    public PacketPlayOutEntityEquipment updateEquipment(ItemStack item) {
        PacketDataSerializer equip = NetworkUtils.createByteBuf();
        equip.d(this.entityId);
        equip.writeByte(switch (this.display) {
            case FakeEntity.DisplaySlot.MAIN_HAND -> 0;
            case FakeEntity.DisplaySlot.OFF_HAND -> 1;
            default -> 5;
        });
        equip.a(CraftItemStack.asNMSCopy((ItemStack)item));
        return new PacketPlayOutEntityEquipment(equip);
    }

    public PacketPlayOutMount addPassengers(Set<Entity> passengers) {
        PacketDataSerializer mount = NetworkUtils.createByteBuf();
        mount.d(this.entityId);
        mount.d(passengers.size());
        for (Entity ent : passengers) {
            mount.d(ent.getEntityId());
        }
        return new PacketPlayOutMount(mount);
    }

    public void setInvisible(boolean flag) {
        if (this.isInvisible == flag) {
            return;
        }
        this.isInvisible = flag;
        NMSUtils.setBit(this.commonDataItem, 5, flag);
        this.commonDataItem.a(true);
    }

    public void setGlowing(boolean flag) {
        if (this.isGlowing == flag) {
            return;
        }
        this.isGlowing = flag;
        NMSUtils.setBit(this.commonDataItem, 6, flag);
        this.commonDataItem.a(true);
    }

    public void setCustomName(String name) {
        IChatBaseComponent component = CraftChatMessage.fromStringOrNull((String)name);
        this.customNameDataItem.a(Optional.ofNullable(component));
        this.customNameDataItem.a(true);
    }

    public void setCustomNameVisible(boolean flag) {
        if (flag == this.isCustomNameVisible) {
            return;
        }
        this.isCustomNameVisible = flag;
        this.customNameVisibleDataItem.a((Object)flag);
        this.customNameVisibleDataItem.a(true);
    }

    public void setSmall(boolean flag) {
        if (this.isSmall == flag) {
            return;
        }
        this.isSmall = flag;
        NMSUtils.setBit(this.standDataItem, 0, flag);
        this.standDataItem.a(true);
    }

    public void setRotation(EulerAngle rotation) {
        Vector3f nRot = NMSUtils.toNMS(rotation);
        if (nRot.equals((Object)this.rotation)) {
            return;
        }
        this.rotation = nRot;
        this.rotationDataItem.a((Object)nRot);
        this.rotationDataItem.a(true);
    }

    public void setDisplay(FakeEntity.DisplaySlot slot) {
        if (this.display == slot) {
            return;
        }
        this.display = slot;
        this.rotationDataItem = switch (slot) {
            case FakeEntity.DisplaySlot.MAIN_HAND -> new DataWatcher.Item(DataAccessors.MAIN_ARM_POSE, (Object)this.rotation);
            case FakeEntity.DisplaySlot.OFF_HAND -> new DataWatcher.Item(DataAccessors.OFF_ARM_POSE, (Object)this.rotation);
            default -> new DataWatcher.Item(DataAccessors.HEAD_POSE, (Object)this.rotation);
        };
        this.rotationDataItem.a(true);
    }

    public void createRealRenderer(org.bukkit.World world, ItemStack itemStack) {
        WorldServer level = ((CraftWorld)world).getHandle();
        EntityArmorStand armorStand = new EntityArmorStand(EntityTypes.c, (World)level);
        armorStand.setPosition(this.location.getX() + this.lastOffset.getX(), this.location.getY() + this.lastOffset.getY(), this.location.getZ() + this.lastOffset.getZ());
        armorStand.setYRot((float)this.lastYaw);
        armorStand.m((float)this.lastYaw);
        armorStand.setHeadRotation((float)this.lastYaw);
        armorStand.setMarker(true);
        armorStand.setSmall(this.isSmall());
        armorStand.setNoGravity(true);
        armorStand.setInvisible(true);
        armorStand.setHeadPose(this.rotation);
        armorStand.setSlot(EnumItemSlot.f, CraftItemStack.asNMSCopy((ItemStack)itemStack));
        level.addEntity((net.minecraft.world.entity.Entity)armorStand);
    }

    private List<DataWatcher.Item<?>> packData(boolean isAll) {
        if (isAll) {
            return List.of(this.commonDataItem, this.airTickDataItem, this.customNameDataItem, this.customNameVisibleDataItem, this.standDataItem, this.rotationDataItem);
        }
        ArrayList list = new ArrayList();
        this.addDirtyData(list, this.commonDataItem);
        this.addDirtyData(list, this.airTickDataItem);
        this.addDirtyData(list, this.customNameDataItem);
        this.addDirtyData(list, this.customNameVisibleDataItem);
        this.addDirtyData(list, this.standDataItem);
        this.addDirtyData(list, this.rotationDataItem);
        return list;
    }

    private void addDirtyData(List<DataWatcher.Item<?>> list, DataWatcher.Item<?> dataItem) {
        if (dataItem.c()) {
            list.add(dataItem);
            dataItem.a(false);
        }
    }

    private void updateOffset(byte yaw) {
        if (this.lastYaw == yaw && this.lastOffset != null) {
            return;
        }
        this.lastYaw = yaw;
        this.lastOffset = this.display.getPivotOffset(this.isSmall, yaw);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Vector getLocation() {
        return this.location;
    }

    public boolean isInvisible() {
        return this.isInvisible;
    }

    public boolean isGlowing() {
        return this.isGlowing;
    }

    public boolean isSmall() {
        return this.isSmall;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public FakeEntity.DisplaySlot getDisplay() {
        return this.display;
    }
}

