/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_17_R1.entity.controller.special;

import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.nms.v1_17_R1.entity.controller.MoveControlWrapper;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.phys.Vec3D;

public class VexMoveControlWrapper
extends MoveControlWrapper {
    private final EntityVex vex;

    public VexMoveControlWrapper(EntityVex mob, ControllerMove control, ModeledEntity model) {
        super((EntityInsentient)mob, control, model);
        this.vex = mob;
    }

    @Override
    protected void defaultTick() {
        ControllerMove.Operation operation = this.getOperation();
        switch (operation) {
            case a: {
                this.modeledEntity.setState(ModelState.IDLE);
                break;
            }
            case b: 
            case c: {
                this.modeledEntity.setState(ModelState.WALK);
                break;
            }
            case d: {
                this.modeledEntity.setState(ModelState.JUMP);
            }
        }
        if (operation == ControllerMove.Operation.b) {
            Vec3D delta = new Vec3D(this.d() - this.vex.locX(), this.e() - this.vex.locY(), this.f() - this.vex.locZ());
            double distance = delta.f();
            boolean distanceCheck = distance < this.vex.getBoundingBox().a();
            boolean isCharging = this.vex.isCharging();
            boolean isWantedWithinHitbox = this.vex.getBoundingBox().e(this.d(), this.e(), this.f());
            if (distanceCheck && (!isCharging || isWantedWithinHitbox)) {
                operation = ControllerMove.Operation.a;
                this.vex.setMot(this.vex.getMot().a(0.5));
            } else {
                this.vex.setMot(this.vex.getMot().e(delta.a(this.c() * 0.05 / distance)));
                if (this.vex.getGoalTarget() == null) {
                    Vec3D vec3d1 = this.vex.getMot();
                    this.vex.setYRot((float)MathHelper.d((double)vec3d1.b, (double)vec3d1.d) * -57.295776f);
                } else {
                    double d1 = this.vex.getGoalTarget().locX() - this.vex.locX();
                    double d2 = this.vex.getGoalTarget().locZ() - this.vex.locZ();
                    this.vex.setYRot((float)MathHelper.d((double)d1, (double)d2) * -57.295776f);
                }
                this.vex.aX = this.vex.getYRot();
            }
        }
        this.setOperation(operation);
    }
}

