/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_17_R1.entity.controller;

import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.Mountable;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.utils.FieldUtils;
import com.ticxo.modelengine.nms.v1_17_R1.NMSFields;
import java.lang.reflect.Field;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class MoveControlWrapper
extends ControllerMove
implements MoveController {
    private static final Field operationField = FieldUtils.getField(ControllerMove.class, NMSFields.MOVECONTROL_operation);
    protected final ModeledEntity modeledEntity;
    protected final MountManager mountManager;
    protected final ControllerMove original;
    protected ControllerMove.Operation k;
    protected boolean isOnGround;

    public MoveControlWrapper(EntityInsentient mob, ControllerMove control, ModeledEntity model) {
        super(mob);
        this.original = control;
        this.modeledEntity = model;
        this.mountManager = model.getMountManager();
        this.k = ControllerMove.Operation.a;
    }

    public boolean b() {
        return this.original.b();
    }

    public double c() {
        return this.original.c();
    }

    public void a(double var0, double var2, double var4, double var6) {
        this.original.a(var0, var2, var4, var6);
        if (this.k != ControllerMove.Operation.d) {
            this.k = ControllerMove.Operation.b;
        }
    }

    public void a(float var0, float var1) {
        this.original.a(var0, var1);
        this.k = ControllerMove.Operation.c;
    }

    public void a() {
        this.isOnGround = this.d.isOnGround();
        if (this.mountManager != null && this.mountManager.isControlled()) {
            this.d.setOnGround(true);
            this.controlledTick();
        } else {
            this.defaultTick();
        }
        if (this.mountManager != null) {
            this.passengerTick();
        }
    }

    protected void controlledTick() {
        this.d.u(0.0f);
        this.d.w(0.0f);
        MountController controller = this.mountManager.getDriverController();
        if (controller == null) {
            return;
        }
        if (controller.getInput() == null) {
            controller.setInput(new MountController.MountInput());
        }
        controller.updateDriverMovement(this, this.modeledEntity);
        controller.updateRiderPosition(this, this.mountManager.getDriverBone());
    }

    protected void defaultTick() {
        switch (this.k) {
            case a: {
                this.modeledEntity.setState(ModelState.IDLE);
                break;
            }
            case b: 
            case c: {
                this.modeledEntity.setState(ModelState.WALK);
                break;
            }
            case d: {
                this.modeledEntity.setState(ModelState.JUMP);
            }
        }
        this.original.a();
        switch (this.k) {
            case c: {
                this.k = ControllerMove.Operation.a;
                break;
            }
            case b: {
                this.k = this.getOperation();
                break;
            }
            case d: {
                if (!this.d.isOnGround()) break;
                this.k = ControllerMove.Operation.a;
            }
        }
    }

    protected void passengerTick() {
        if (!this.mountManager.hasPassengers()) {
            return;
        }
        for (Entity entity : this.mountManager.getPassengers().keySet()) {
            Mountable mountable = this.mountManager.getPassengers().get(entity);
            MountController controller = this.mountManager.getController(entity.getUniqueId());
            if (controller == null) continue;
            if (controller.getInput() == null) {
                controller.setInput(new MountController.MountInput());
            }
            controller.updatePassengerMovement(this, this.modeledEntity);
            controller.updateRiderPosition(this, mountable);
        }
    }

    protected void setOperation(ControllerMove.Operation operation) {
        try {
            operationField.set(this.original, operation);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.k = operation;
    }

    protected ControllerMove.Operation getOperation() {
        try {
            return (ControllerMove.Operation)operationField.get(this.original);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return ControllerMove.Operation.a;
        }
    }

    public double d() {
        return this.original.d();
    }

    public double e() {
        return this.original.e();
    }

    public double f() {
        return this.original.f();
    }

    @Override
    public void move(float side, float front, float speedModifier) {
        float speed = this.getSpeed();
        this.d.r(speed * speedModifier);
        this.d.u(front);
        this.d.w(side);
    }

    @Override
    public void jump() {
        this.d.getControllerJump().jump();
    }

    @Override
    public void setVelocity(double x, double y, double z) {
        this.d.setMot(x, y, z);
    }

    @Override
    public void addVelocity(double x, double y, double z) {
        this.d.setMot(this.d.getMot().add(x, y, z));
    }

    @Override
    public void nullifyFallDistance() {
        this.d.K = 0.0f;
    }

    @Override
    public void movePassenger(Entity entity, double x, double y, double z) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        double seatY = y + nmsEntity.bk();
        nmsEntity.setPosition(x, seatY, z);
        nmsEntity.setMot(Vec3D.a);
        this.d.K = 0.0f;
        if (nmsEntity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)nmsEntity;
            try {
                FieldUtils.getField(PlayerConnection.class, NMSFields.SERVERGAMEPACKETLISTENERIMPL_clientIsFloating).setBoolean(player.b, false);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isOnGround() {
        return this.isOnGround;
    }

    @Override
    public float getSpeed() {
        return (float)this.d.b(GenericAttributes.d);
    }

    @Override
    public Vector getVelocity() {
        return CraftVector.toBukkit((Vec3D)this.d.getMot());
    }
}

