/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.world;

import com.google.common.collect.Lists;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.nms.world.WorldHandler;
import com.ticxo.modelengine.api.utils.math.OrientedBoundingBox;
import com.ticxo.modelengine.api.utils.math.TMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.Chunk;
import net.minecraft.server.v1_16_R3.EntityComplexPart;
import net.minecraft.server.v1_16_R3.EntityEnderDragon;
import net.minecraft.server.v1_16_R3.IChunkProvider;
import net.minecraft.server.v1_16_R3.MathHelper;
import net.minecraft.server.v1_16_R3.MovingObjectPosition;
import net.minecraft.server.v1_16_R3.MovingObjectPositionBlock;
import net.minecraft.server.v1_16_R3.RayTrace;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftRayTraceResult;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class WorldHandlerImpl
implements WorldHandler {
    @Override
    public RayTraceResult asyncRayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<Entity> filter) {
        RayTraceResult blockHit = this.asyncRayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks);
        Vector startVec = null;
        double blockHitDistance = maxDistance;
        if (blockHit != null) {
            startVec = start.toVector();
            blockHitDistance = TMath.fastSqrt(startVec.distanceSquared(blockHit.getHitPosition()));
        }
        RayTraceResult entityHit = this.asyncRayTraceEntities(start, direction, blockHitDistance, raySize, filter);
        if (blockHit == null) {
            return entityHit;
        }
        if (entityHit == null) {
            return blockHit;
        }
        double entityHitDistanceSquared = startVec.distanceSquared(entityHit.getHitPosition());
        return entityHitDistanceSquared < blockHitDistance * blockHitDistance ? entityHit : blockHit;
    }

    private RayTraceResult asyncRayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        if (maxDistance < 0.0 || start.getWorld() == null) {
            return null;
        }
        WorldServer level = ((CraftWorld)start.getWorld()).getHandle();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        Vec3D startPos = new Vec3D(start.getX(), start.getY(), start.getZ());
        Vec3D endPos = new Vec3D(start.getX() + dir.getX(), start.getY() + dir.getY(), start.getZ() + dir.getZ());
        MovingObjectPositionBlock nmsHitResult = level.rayTrace(new RayTrace(startPos, endPos, ignorePassableBlocks ? RayTrace.BlockCollisionOption.COLLIDER : RayTrace.BlockCollisionOption.OUTLINE, CraftFluidCollisionMode.toNMS((FluidCollisionMode)fluidCollisionMode), null));
        return CraftRayTraceResult.fromNMS((org.bukkit.World)start.getWorld(), (MovingObjectPosition)nmsHitResult);
    }

    private RayTraceResult asyncRayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> filter) {
        if (maxDistance < 0.0 || start.getWorld() == null) {
            return null;
        }
        WorldServer level = ((CraftWorld)start.getWorld()).getHandle();
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir).expand(raySize);
        Collection<Entity> entities = this.asyncGetNearbyEntities((World)level, aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            RayTraceResult hitResult;
            SubHitbox bone = ModelEngineAPI.getModelTicker().getSubHitboxBone(entity.getUniqueId());
            if (bone != null && bone.isOBB()) {
                OrientedBoundingBox orientedBoundingBox = bone.getSubHitboxEntity().getObbInstance();
                if (orientedBoundingBox == null) continue;
                hitResult = orientedBoundingBox.rayTrace(startPos, direction, maxDistance, (Consumer<BoundingBox>)((Consumer)boundingBox -> boundingBox.expand(raySize)));
            } else {
                BoundingBox boundingBox2 = entity.getBoundingBox().expand(raySize);
                hitResult = boundingBox2.rayTrace(startPos, direction, maxDistance);
            }
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    private Collection<Entity> asyncGetNearbyEntities(World level, BoundingBox boundingBox, Predicate<Entity> filter) {
        AxisAlignedBB bb = new AxisAlignedBB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        List<net.minecraft.server.v1_16_R3.Entity> entityList = this.getEntities(level, bb, entity -> true);
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
        Iterator<net.minecraft.server.v1_16_R3.Entity> var7 = entityList.iterator();
        while (var7.hasNext()) {
            net.minecraft.server.v1_16_R3.Entity entity2 = var7.next();
            CraftEntity bukkitEntity = entity2.getBukkitEntity();
            if (filter != null && !filter.test((Entity)bukkitEntity)) continue;
            bukkitEntityList.add((Entity)bukkitEntity);
        }
        return bukkitEntityList;
    }

    private List<net.minecraft.server.v1_16_R3.Entity> getEntities(World level, AxisAlignedBB axisalignedbb, @Nullable Predicate<? super net.minecraft.server.v1_16_R3.Entity> predicate) {
        ArrayList list = Lists.newArrayList();
        int i = MathHelper.floor((double)((axisalignedbb.minX - 2.0) / 16.0));
        int j = MathHelper.floor((double)((axisalignedbb.maxX + 2.0) / 16.0));
        int k = MathHelper.floor((double)((axisalignedbb.minZ - 2.0) / 16.0));
        int l = MathHelper.floor((double)((axisalignedbb.maxZ + 2.0) / 16.0));
        IChunkProvider ichunkprovider = level.getChunkProvider();
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                Chunk chunk = ichunkprovider.getChunkAt(i1, j1, false);
                if (chunk == null) continue;
                this.getEntitiesInChunk(chunk, axisalignedbb, list, predicate);
            }
        }
        return list;
    }

    private void getEntitiesInChunk(Chunk chunk, AxisAlignedBB axisalignedbb, List<net.minecraft.server.v1_16_R3.Entity> list, @Nullable Predicate<? super net.minecraft.server.v1_16_R3.Entity> predicate) {
        int i = MathHelper.floor((double)((axisalignedbb.minY - 2.0) / 16.0));
        int j = MathHelper.floor((double)((axisalignedbb.maxY + 2.0) / 16.0));
        i = MathHelper.clamp((int)i, (int)0, (int)(chunk.entitySlices.length - 1));
        j = MathHelper.clamp((int)j, (int)0, (int)(chunk.entitySlices.length - 1));
        try {
            for (int k = i; k <= j; ++k) {
                List entityslice = chunk.entitySlices[k];
                for (net.minecraft.server.v1_16_R3.Entity entity1 : entityslice) {
                    EntityComplexPart[] aentitycomplexpart;
                    if (!entity1.getBoundingBox().c(axisalignedbb)) continue;
                    if (predicate == null || predicate.test((net.minecraft.server.v1_16_R3.Entity)entity1)) {
                        list.add(entity1);
                    }
                    if (!(entity1 instanceof EntityEnderDragon)) continue;
                    for (EntityComplexPart entitycomplexpart : aentitycomplexpart = ((EntityEnderDragon)entity1).eJ()) {
                        if (entitycomplexpart == null || !entitycomplexpart.getBoundingBox().c(axisalignedbb) || predicate != null && !predicate.test((net.minecraft.server.v1_16_R3.Entity)entitycomplexpart)) continue;
                        list.add((net.minecraft.server.v1_16_R3.Entity)entitycomplexpart);
                    }
                }
            }
        }
        catch (ConcurrentModificationException k) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

