/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.network.interact;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.nms.entity.fake.SubHitboxEntity;
import com.ticxo.modelengine.api.utils.math.TMath;
import java.util.Optional;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.ChatMessage;
import net.minecraft.server.v1_16_R3.CriterionTriggers;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityArrow;
import net.minecraft.server.v1_16_R3.EntityExperienceOrb;
import net.minecraft.server.v1_16_R3.EntityFish;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityItem;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EnumHand;
import net.minecraft.server.v1_16_R3.EnumInteractionResult;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.Item;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.Items;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketListener;
import net.minecraft.server.v1_16_R3.PacketListenerPlayIn;
import net.minecraft.server.v1_16_R3.PacketPlayInUseEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutAttachEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_16_R3.PlayerConnection;
import net.minecraft.server.v1_16_R3.PlayerConnectionUtils;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class PatchedInteractHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void handleInteract(PacketPlayInUseEntity interactPacket, PacketListenerPlayIn listener) {
        int modelEntityId;
        Entity e;
        if (!(listener instanceof PlayerConnection)) {
            return;
        }
        PlayerConnection connection = (PlayerConnection)listener;
        PlayerConnectionUtils.ensureMainThread((Packet)interactPacket, (PacketListener)connection, (WorldServer)connection.player.getWorldServer());
        EntityPlayer player = connection.player;
        if (player.isFrozen()) {
            return;
        }
        WorldServer worldServer = player.getWorldServer();
        if (worldServer == null) {
            return;
        }
        CraftPlayer craftPlayer = player.getBukkitEntity();
        CraftServer craftServer = worldServer.getServer();
        Entity hitboxEntity = interactPacket.a((World)worldServer);
        if (hitboxEntity == player && !player.isSpectator()) {
            connection.disconnect("Cannot interact with self!");
            return;
        }
        player.resetIdleTimer();
        player.setSneaking(interactPacket.e());
        if (hitboxEntity == null) {
            return;
        }
        Entity relayedEntity = hitboxEntity;
        SubHitbox subHitbox = ModelEngineAPI.getModelTicker().getSubHitboxBone(hitboxEntity.getUniqueID());
        if (subHitbox != null && (e = worldServer.getEntity(modelEntityId = subHitbox.getSubHitboxEntity().getRelayed().getEntityId())) != null && e != player) {
            relayedEntity = e;
        }
        if (!worldServer.getWorldBorder().a(relayedEntity.getChunkCoordinates())) {
            return;
        }
        if (!PatchedInteractHandler.canInteract(player, hitboxEntity)) {
            return;
        }
        Entity finalEntity = relayedEntity;
        EnumHand enumhand = interactPacket.c();
        ItemStack itemstack = enumhand != null ? player.b(enumhand).cloneItemStack() : ItemStack.b;
        Optional<Object> optional = Optional.empty();
        ItemStack itemInHand = player.b(interactPacket.c() == null ? EnumHand.MAIN_HAND : interactPacket.c());
        if (interactPacket.b() == PacketPlayInUseEntity.EnumEntityUseAction.INTERACT || interactPacket.b() == PacketPlayInUseEntity.EnumEntityUseAction.INTERACT_AT) {
            PlayerInteractEntityEvent event;
            Item origItem;
            boolean triggerLeashUpdate = itemInHand != null && itemInHand.getItem() == Items.LEAD && finalEntity instanceof EntityInsentient;
            Item item = origItem = player.inventory.getItemInHand() == null ? null : player.inventory.getItemInHand().getItem();
            if (interactPacket.b() == PacketPlayInUseEntity.EnumEntityUseAction.INTERACT) {
                event = new PlayerInteractEntityEvent((Player)craftPlayer, (org.bukkit.entity.Entity)finalEntity.getBukkitEntity(), interactPacket.c() == EnumHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND);
            } else {
                Vec3D target = interactPacket.d();
                event = new PlayerInteractAtEntityEvent((Player)craftPlayer, (org.bukkit.entity.Entity)finalEntity.getBukkitEntity(), new Vector(target.x, target.y, target.z), interactPacket.c() == EnumHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND);
            }
            craftServer.getPluginManager().callEvent((Event)event);
            if (finalEntity instanceof EntityFish && origItem != null && origItem.getItem() == Items.WATER_BUCKET && (event.isCancelled() || player.inventory.getItemInHand() == null || player.inventory.getItemInHand().getItem() != origItem)) {
                connection.sendPacket((Packet)new PacketPlayOutSpawnEntityLiving((EntityLiving)((EntityFish)finalEntity)));
                player.updateInventory(player.activeContainer);
            }
            if (triggerLeashUpdate && (event.isCancelled() || player.inventory.getItemInHand() == null || player.inventory.getItemInHand().getItem() != origItem)) {
                connection.sendPacket((Packet)new PacketPlayOutAttachEntity(finalEntity, ((EntityInsentient)finalEntity).getLeashHolder()));
            }
            if (event.isCancelled() || player.inventory.getItemInHand() == null || player.inventory.getItemInHand().getItem() != origItem) {
                connection.sendPacket((Packet)new PacketPlayOutEntityMetadata(finalEntity.getId(), finalEntity.getDataWatcher(), true));
            }
            if (event.isCancelled()) {
                return;
            }
        }
        if (interactPacket.b() == PacketPlayInUseEntity.EnumEntityUseAction.INTERACT) {
            if (finalEntity instanceof SubHitboxEntity) {
                SubHitboxEntity hitbox = (SubHitboxEntity)finalEntity;
                hitbox.onFakeInteract((Player)craftPlayer, enumhand == EnumHand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
                return;
            }
            if (hitboxEntity instanceof SubHitboxEntity) {
                SubHitboxEntity hitbox = (SubHitboxEntity)hitboxEntity;
                hitbox.onRealInteract((Player)craftPlayer, enumhand == EnumHand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
            }
            optional = Optional.of(player.a(hitboxEntity, enumhand));
            if (itemInHand != null && !itemInHand.isEmpty() && itemInHand.getCount() <= -1) {
                player.updateInventory(player.activeContainer);
            }
        } else if (interactPacket.b() == PacketPlayInUseEntity.EnumEntityUseAction.INTERACT_AT) {
            if (finalEntity instanceof SubHitboxEntity) {
                return;
            }
            optional = Optional.of(finalEntity.a((EntityHuman)player, interactPacket.d(), enumhand));
            if (itemInHand != null && !itemInHand.isEmpty() && itemInHand.getCount() <= -1) {
                player.updateInventory(player.activeContainer);
            }
        } else if (interactPacket.b() == PacketPlayInUseEntity.EnumEntityUseAction.ATTACK) {
            if (hitboxEntity instanceof EntityItem || hitboxEntity instanceof EntityExperienceOrb || hitboxEntity instanceof EntityArrow || hitboxEntity == player && !player.isSpectator()) {
                connection.disconnect((IChatBaseComponent)new ChatMessage("multiplayer.disconnect.invalid_entity_attacked"));
                LOGGER.warn("Player {} tried to attack an invalid entity", (Object)player.getDisplayName().getString());
                return;
            }
            player.attack(hitboxEntity);
            if (itemInHand != null && !itemInHand.isEmpty() && itemInHand.getCount() <= -1) {
                player.updateInventory(player.activeContainer);
            }
        }
        if (optional.isPresent() && ((EnumInteractionResult)optional.get()).a()) {
            CriterionTriggers.P.a(player, itemstack, finalEntity);
            if (((EnumInteractionResult)optional.get()).b()) {
                player.swingHand(enumhand, true);
            }
        }
    }

    private static boolean canInteract(EntityPlayer player, Entity entity) {
        AxisAlignedBB aabb = entity.getBoundingBox();
        Vec3D delta = player.j(1.0f).d(aabb.f());
        Vector q = new Vector(Math.max(Math.abs(delta.x) - aabb.b() / 2.0, 0.0), Math.max(Math.abs(delta.y) - aabb.c() / 2.0, 0.0), Math.max(Math.abs(delta.z) - aabb.d() / 2.0, 0.0));
        return q.lengthSquared() < 36.0;
    }

    private static boolean canInteractDir(EntityPlayer player, Entity entity) {
        AxisAlignedBB aabb = entity.getBoundingBox();
        return TMath.isBoundingBoxWithinDistance(new Vector(player.locX(), player.getHeadY(), player.locZ()), PatchedInteractHandler.getDirection(player), new BoundingBox(aabb.minX, aabb.minY, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ), 6.0);
    }

    private static Vector getDirection(EntityPlayer player) {
        Vector vector = new Vector();
        double rotX = player.getHeadRotation();
        double rotY = player.pitch;
        vector.setY(-Math.sin(Math.toRadians(rotY)));
        double xz = Math.cos(Math.toRadians(rotY));
        vector.setX(-xz * Math.sin(Math.toRadians(rotX)));
        vector.setZ(xz * Math.cos(Math.toRadians(rotX)));
        return vector;
    }
}

