/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.network;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelPipeline;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.minecraft.server.v1_16_R3.DataWatcher;
import net.minecraft.server.v1_16_R3.EnumProtocol;
import net.minecraft.server.v1_16_R3.EnumProtocolDirection;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketDataSerializer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class NetworkUtils {
    private static boolean compressPacket = true;

    protected static void updateConfigs() {
        compressPacket = ConfigProperty.COMPRESS_PACKET.getBoolean();
    }

    public static PacketDataSerializer createByteBuf() {
        return new PacketDataSerializer(Unpooled.buffer());
    }

    public static Integer getPacketId(Packet<?> packet) {
        return EnumProtocol.PLAY.a(EnumProtocolDirection.CLIENTBOUND, packet);
    }

    public static void packMeta(List<DataWatcher.Item<?>> dirty, PacketDataSerializer meta) {
        try {
            DataWatcher.a(dirty, (PacketDataSerializer)meta);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static PacketDataSerializer createCompressedPacket(Packet<?> packet) {
        Integer packetId = NetworkUtils.getPacketId(packet);
        if (packetId == null) {
            return null;
        }
        PacketDataSerializer bb = NetworkUtils.createByteBuf();
        bb.writeByte(packetId.intValue());
        try {
            packet.b(bb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bb;
    }

    public static PacketDataSerializer readData(Packet<?> packet) {
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        try {
            packet.b(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buf;
    }

    public static <T extends Packet<?>> T writeData(T packet, PacketDataSerializer buf) {
        try {
            packet.a(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return packet;
    }

    public static void send(Set<Player> players, Packet<?> ... packets) {
        for (Player player : players) {
            NetworkUtils.send(player, packets);
        }
    }

    public static void send(Player player, Packet<?> ... packets) {
        ChannelPipeline pipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (pipeline == null) {
            return;
        }
        if (compressPacket) {
            for (Packet<?> packet : packets) {
                PacketDataSerializer byteBuf;
                if (packet == null || (byteBuf = NetworkUtils.createCompressedPacket(packet)) == null) continue;
                pipeline.write((Object)byteBuf);
            }
        } else {
            for (Packet<?> packet : packets) {
                if (packet == null) continue;
                pipeline.write(packet);
            }
        }
        pipeline.flush();
    }

    public static void send(Set<Player> players, List<Packet<?>> packets) {
        for (Player player : players) {
            NetworkUtils.send(player, packets);
        }
    }

    public static void send(Player player, List<Packet<?>> packets) {
        ChannelPipeline pipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (pipeline == null) {
            return;
        }
        if (compressPacket) {
            for (Packet<?> packet : packets) {
                PacketDataSerializer byteBuf;
                if (packet == null || (byteBuf = NetworkUtils.createCompressedPacket(packet)) == null) continue;
                pipeline.write((Object)byteBuf);
            }
        } else {
            for (Packet<?> packet : packets) {
                if (packet == null) continue;
                pipeline.write(packet);
            }
        }
        pipeline.flush();
    }

    public static void send(Player player, PacketDataSerializer ... packets) {
        ChannelPipeline pipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (pipeline == null) {
            return;
        }
        for (PacketDataSerializer packet : packets) {
            if (packet == null) continue;
            pipeline.write((Object)packet);
        }
        pipeline.flush();
    }
}

