/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.network;

import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.mananger.ModelTicker;
import com.ticxo.modelengine.api.model.mananger.VFXTicker;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.nms.v1_16_R3.network.NetworkUtils;
import com.ticxo.modelengine.nms.v1_16_R3.network.PacketInterceptor;
import com.ticxo.modelengine.nms.v1_16_R3.network.interact.ServerboundInteractPacketWrapper;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EnumChatFormat;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketDataSerializer;
import net.minecraft.server.v1_16_R3.PacketPlayInSteerVehicle;
import net.minecraft.server.v1_16_R3.PacketPlayInUseEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_16_R3.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class ModelEngineChannelHandler
extends ChannelDuplexHandler {
    private final Player bukkit;
    private final EntityPlayer player;
    private final ModelTicker ticker;
    private final VFXTicker vfxTicker;
    private final PacketInterceptor writeInterceptors;
    private final PacketInterceptor readInterceptors;

    public ModelEngineChannelHandler(Player player) {
        this.bukkit = player;
        this.player = ((CraftPlayer)player).getHandle();
        this.ticker = ModelEngineAPI.getModelTicker();
        this.vfxTicker = ModelEngineAPI.getVFXTicker();
        this.writeInterceptors = new PacketInterceptor().register(PacketPlayOutSpawnEntity.class, this::handleAddEntity).register(PacketPlayOutSpawnEntityLiving.class, this::handleAddMob).register(PacketPlayOutNamedEntitySpawn.class, this::handleAddPlayer).register(PacketPlayOutEntityDestroy.class, this::handleRemoveEntities).register(PacketPlayOutScoreboardTeam.class, this::handleSetPlayerTeam).register(PacketPlayOutEntityMetadata.class, this::handleSetEntityData);
        this.readInterceptors = new PacketInterceptor().register(PacketPlayInSteerVehicle.class, this::handlePlayerInput).register(PacketPlayInUseEntity.class, this::handleInteract);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof Packet)) {
            super.write(ctx, (Object)msg, promise);
            return;
        }
        Packet packet = (Packet)msg;
        msg = this.writeInterceptors.accept(packet);
        if (msg == null) {
            return;
        }
        super.write(ctx, msg, promise);
        this.writeInterceptors.acceptPost(packet);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof Packet)) {
            super.channelRead(ctx, (Object)msg);
            return;
        }
        Packet packet = (Packet)msg;
        msg = this.readInterceptors.accept(packet);
        if (msg == null) {
            return;
        }
        super.channelRead(ctx, msg);
        this.readInterceptors.acceptPost(packet);
    }

    private boolean showModel(int id) {
        VFX vfx;
        boolean shouldClear = false;
        ModeledEntity model = this.ticker.getModeledEntity(id);
        if (model != null) {
            model.showToPlayer(this.bukkit);
            boolean bl = shouldClear = !model.isBaseEntityVisible();
        }
        if ((vfx = this.vfxTicker.getVFX(id)) != null) {
            vfx.showToPlayer(this.bukkit);
            shouldClear |= !vfx.isBaseEntityVisible();
        }
        return shouldClear;
    }

    private boolean showModel(UUID id) {
        VFX vfx;
        boolean shouldClear = false;
        ModeledEntity model = this.ticker.getModeledEntity(id);
        if (model != null) {
            model.showToPlayer(this.bukkit);
            boolean bl = shouldClear = !model.isBaseEntityVisible();
        }
        if ((vfx = this.vfxTicker.getVFX(id)) != null) {
            vfx.showToPlayer(this.bukkit);
            shouldClear |= !vfx.isBaseEntityVisible();
        }
        return shouldClear;
    }

    private void hideModel(int id) {
        VFX vfx;
        ModeledEntity model = this.ticker.getModeledEntity(id);
        if (model != null && (!model.getBase().isDead() || model.getBase().isDead() && model.getAnimationState(false))) {
            model.hideFromPlayer(this.bukkit);
        }
        if ((vfx = this.vfxTicker.getVFX(id)) != null) {
            vfx.hideFromPlayer(this.bukkit);
        }
    }

    private Packet<?> handleAddEntity(PacketPlayOutSpawnEntity addEntityPacket) {
        PacketDataSerializer byteBuf = NetworkUtils.readData(addEntityPacket);
        int id = byteBuf.i();
        return this.showModel(id) ? null : addEntityPacket;
    }

    private Packet<?> handleAddMob(PacketPlayOutSpawnEntityLiving addMobPacket) {
        PacketDataSerializer byteBuf = NetworkUtils.readData(addMobPacket);
        int id = byteBuf.i();
        return this.showModel(id) ? null : addMobPacket;
    }

    private Packet<?> handleAddPlayer(PacketPlayOutNamedEntitySpawn addPlayerPacket) {
        PacketDataSerializer byteBuf = NetworkUtils.readData(addPlayerPacket);
        byteBuf.i();
        return this.showModel(byteBuf.k()) ? null : addPlayerPacket;
    }

    private Packet<?> handleRemoveEntities(PacketPlayOutEntityDestroy removeEntitiesPacket) {
        PacketDataSerializer byteBuf = NetworkUtils.readData(removeEntitiesPacket);
        for (int id : byteBuf.b()) {
            this.hideModel(id);
        }
        return removeEntitiesPacket;
    }

    private Packet<?> handleSetPlayerTeam(PacketPlayOutScoreboardTeam teamPacket) {
        PacketDataSerializer byteBuf = NetworkUtils.readData(teamPacket);
        String name = byteBuf.e(16);
        byte method = byteBuf.readByte();
        if (method == 1 || method == 2) {
            return teamPacket;
        }
        IChatBaseComponent displayName = null;
        byte options = 0;
        String nametagVisibility = null;
        String collisionRule = null;
        EnumChatFormat color = null;
        IChatBaseComponent playerPrefix = null;
        IChatBaseComponent playerSuffix = null;
        ArrayList<String> players = new ArrayList<String>();
        if (method == 0) {
            displayName = byteBuf.h();
            options = byteBuf.readByte();
            nametagVisibility = byteBuf.e(40);
            collisionRule = byteBuf.e(40);
            color = (EnumChatFormat)byteBuf.a(EnumChatFormat.class);
            playerPrefix = byteBuf.h();
            playerSuffix = byteBuf.h();
        }
        if (method == 0 || method == 3 || method == 4) {
            int length = byteBuf.i();
            for (int i = 0; i < length; ++i) {
                players.add(byteBuf.e(40));
            }
        }
        if (players.isEmpty()) {
            return teamPacket;
        }
        Set renderers = Sets.newConcurrentHashSet();
        for (String member : players) {
            UUID uuid;
            try {
                uuid = UUID.fromString(member);
            }
            catch (IllegalArgumentException ignored) {
                Player player = Bukkit.getPlayerExact((String)member);
                if (player == null) continue;
                uuid = player.getUniqueId();
            }
            ModeledEntity model = ModelEngineAPI.getModeledEntity(uuid);
            if (model == null) continue;
            for (ActiveModel activeModel : model.getModels().values()) {
                for (BoneRenderer renderer : activeModel.getRendererHandler().getFakeEntity().values()) {
                    renderers.add(renderer.getRendererUUID().toString());
                }
            }
        }
        players.addAll(renderers);
        PacketDataSerializer newBuf = NetworkUtils.createByteBuf();
        newBuf.a(name);
        newBuf.writeByte((int)method);
        if (method == 0) {
            newBuf.a(displayName);
            newBuf.writeByte((int)options);
            newBuf.a(nametagVisibility);
            newBuf.a(collisionRule);
            newBuf.a((Enum)color);
            newBuf.a(playerPrefix);
            newBuf.a(playerSuffix);
        }
        newBuf.d(players.size());
        for (String s : players) {
            newBuf.a(s);
        }
        return NetworkUtils.writeData(teamPacket, newBuf);
    }

    private Packet<?> handleSetEntityData(PacketPlayOutEntityMetadata dataPacket) {
        PacketDataSerializer byteBuf = NetworkUtils.readData(dataPacket);
        int id = byteBuf.i();
        if (id != this.player.getId()) {
            return dataPacket;
        }
        ModeledEntity model = ModelEngineAPI.getModeledEntity(this.player.getUniqueID());
        if (model == null || model.isBaseEntityVisible()) {
            return dataPacket;
        }
        ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(this.bukkit, true);
        return null;
    }

    private Packet<?> handlePlayerInput(PacketPlayInSteerVehicle inputPacket) {
        MountController controller = ModelEngineAPI.getPlayerMountController(this.player.getUniqueID());
        if (controller != null) {
            MountController.MountInput input = new MountController.MountInput(inputPacket.b(), inputPacket.c(), inputPacket.d(), inputPacket.e());
            controller.setInput(input);
        }
        return inputPacket;
    }

    private Packet<?> handleInteract(PacketPlayInUseEntity interactPacket) {
        Integer relayed = ModelEngineAPI.api.getInteractionTicker().getRelayedId(this.player.getId());
        if (relayed != null) {
            return new ServerboundInteractPacketWrapper(relayed, interactPacket);
        }
        return interactPacket;
    }
}

