/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.entity.range;

import com.google.common.collect.ImmutableSet;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.utils.FieldUtils;
import com.ticxo.modelengine.nms.v1_16_R3.NMSFields;
import com.ticxo.modelengine.nms.v1_16_R3.network.NetworkUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EntityTrackerEntry;
import net.minecraft.server.v1_16_R3.PlayerChunkMap;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class RangeManagerImpl
implements RangeManager {
    private final Supplier<PlayerChunkMap.EntityTracker> instanceSupplier;
    private PlayerChunkMap.EntityTracker tracked;
    private EntityTrackerEntry entity;
    private int renderDistance;

    public RangeManagerImpl(Supplier<PlayerChunkMap.EntityTracker> tracked) {
        this.instanceSupplier = tracked;
        this.getInstance();
    }

    protected void getInstance() {
        if (this.tracked != null) {
            return;
        }
        this.tracked = this.instanceSupplier.get();
        if (this.tracked == null) {
            return;
        }
        try {
            this.entity = (EntityTrackerEntry)FieldUtils.getField(PlayerChunkMap.EntityTracker.class, NMSFields.TRACKEDENTITY_EntityTrackerEntry).get(this.tracked);
            this.renderDistance = FieldUtils.getField(PlayerChunkMap.EntityTracker.class, NMSFields.TRACKEDENTITY_range).getInt(this.tracked);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void forceSpawn(Player player) {
        this.getInstance();
        if (this.tracked == null) {
            return;
        }
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        this.entity.a(packet -> {
            Integer id = NetworkUtils.getPacketId(packet);
            if (id == null) {
                nmsPlayer.playerConnection.networkManager.sendPacket(packet);
            }
            NetworkUtils.send(player, packet);
        }, nmsPlayer);
    }

    @Override
    public void updatePlayer(Player player) {
        this.getInstance();
        if (this.tracked == null) {
            return;
        }
        this.tracked.updatePlayer(((CraftPlayer)player).getHandle());
    }

    @Override
    public void removePlayer(Player player) {
        this.getInstance();
        if (this.tracked == null) {
            return;
        }
        this.tracked.clear(((CraftPlayer)player).getHandle());
    }

    @Override
    public void setRenderDistance(int radius) {
        this.getInstance();
        if (this.tracked == null) {
            return;
        }
        this.renderDistance = radius;
        try {
            FieldUtils.getField(PlayerChunkMap.EntityTracker.class, NMSFields.TRACKEDENTITY_range).setInt(this.tracked, radius);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Set<Player> getPlayerInRange() {
        this.getInstance();
        if (this.tracked == null) {
            return ImmutableSet.of();
        }
        HashSet<Player> set = new HashSet<Player>();
        this.tracked.trackedPlayers.forEach(entityPlayer -> set.add((Player)entityPlayer.getBukkitEntity()));
        return set;
    }

    @Override
    public int getRenderDistance() {
        return this.renderDistance;
    }
}

