/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.entity.fake.bone;

import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.NametagPoint;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_16_R3.entity.fake.FakeArmorStand;
import com.ticxo.modelengine.nms.v1_16_R3.network.NetworkUtils;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketListenerPlayOut;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import org.bukkit.entity.Player;

public class NametagPointImplAC
implements NametagPoint {
    private String customName;
    private boolean customNameVisible;
    private ModelBone bone;
    private RangeManager rangeManager;
    private FakeArmorStand armorStand;
    private boolean isInitialized = false;
    private final boolean isC;

    public NametagPointImplAC(ModelBone bone, boolean isC) {
        this.setBone(bone);
        this.isC = isC;
    }

    @Override
    public void setBone(ModelBone bone) {
        this.bone = bone;
        this.rangeManager = bone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        this.armorStand = new FakeArmorStand(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.armorStand.setInvisible(true);
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn();
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorSpawn, armorMeta});
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn();
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        NetworkUtils.send(player, new Packet[]{armorSpawn, armorMeta});
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{remove});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.getEntityId()});
        NetworkUtils.send(player, new Packet[]{remove});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        Packet<PacketListenerPlayOut> armorPosition = this.isC ? this.armorStand.updatePositionCalibrated(this.bone.getPosition()) : this.armorStand.updatePosition(this.bone.getPosition());
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(false);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorPosition, armorMeta});
    }

    @Override
    public void setCustomName(String name) {
        if (this.customName != null && this.customName.equals(name)) {
            return;
        }
        this.customName = name;
        this.armorStand.setCustomName(name);
    }

    @Override
    public void setCustomNameVisible(boolean flag) {
        this.customNameVisible = flag;
        this.armorStand.setCustomNameVisible(flag);
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public boolean isCustomNameVisible() {
        return this.customNameVisible;
    }

    public FakeArmorStand getArmorStand() {
        return this.armorStand;
    }
}

