/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.entity.fake.bone;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.MountPoint;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_16_R3.entity.fake.FakeAreaEffectCloud;
import com.ticxo.modelengine.nms.v1_16_R3.entity.fake.FakeArmorStand;
import com.ticxo.modelengine.nms.v1_16_R3.network.NetworkUtils;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_16_R3.PacketPlayOutMount;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class MountPointImplB
implements MountPoint {
    private final Set<Entity> passengers = Sets.newConcurrentHashSet();
    private ModelBone bone;
    private RangeManager rangeManager;
    private FakeAreaEffectCloud cloud;
    private FakeArmorStand armorStand;
    private boolean isInitialized = false;

    public MountPointImplB(ModelBone bone) {
        this.setBone(bone);
    }

    @Override
    public void setBone(ModelBone bone) {
        this.bone = bone;
        this.rangeManager = bone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        this.cloud = new FakeAreaEffectCloud(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.armorStand = new FakeArmorStand(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.armorStand.setInvisible(true);
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity cloudSpawn = this.cloud.spawn();
        PacketPlayOutEntityMetadata cloudMeta = this.cloud.meta();
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        PacketPlayOutMount mount = this.cloud.addPassengers(this.armorStand.getEntityId());
        PacketPlayOutMount passengerMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{cloudSpawn, cloudMeta, armorSpawn, armorMeta, mount, passengerMount});
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity cloudSpawn = this.cloud.spawn();
        PacketPlayOutEntityMetadata cloudMeta = this.cloud.meta();
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        PacketPlayOutMount mount = this.cloud.addPassengers(this.armorStand.getEntityId());
        PacketPlayOutMount passengerMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(player, new Packet[]{cloudSpawn, cloudMeta, armorSpawn, armorMeta, mount, passengerMount});
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{remove});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(player, new Packet[]{remove});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        Vector pos = this.bone.getPosition();
        this.armorStand.getLocation().zero().add(pos);
        PacketPlayOutEntityTeleport cloudPosition = this.cloud.updatePosition(pos);
        PacketPlayOutEntity.PacketPlayOutEntityLook armorYaw = this.armorStand.updateYaw(this.bone.getYaw(), false);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{cloudPosition, armorYaw});
    }

    @Override
    public void addPassengers(Entity ... passengers) {
        this.passengers.addAll(Arrays.asList(passengers));
        PacketPlayOutMount passengerMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{passengerMount});
    }

    @Override
    public void removePassengers(Entity ... passengers) {
        Arrays.asList(passengers).forEach(this.passengers::remove);
        PacketPlayOutMount passengerMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{passengerMount});
    }

    @Override
    public void clearPassengers() {
        this.passengers.clear();
        PacketPlayOutMount passengerMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{passengerMount});
    }

    @Override
    public Set<Entity> getPassengers() {
        return ImmutableSet.copyOf(this.passengers);
    }

    public FakeAreaEffectCloud getCloud() {
        return this.cloud;
    }

    public FakeArmorStand getArmorStand() {
        return this.armorStand;
    }
}

