/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.entity.fake;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.nms.v1_16_R3.entity.fake.DataAccessors;
import com.ticxo.modelengine.nms.v1_16_R3.network.NetworkUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_16_R3.DataWatcher;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.PacketDataSerializer;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_16_R3.PacketPlayOutMount;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import org.bukkit.util.Vector;

public class FakeAreaEffectCloud {
    private final int entityId;
    private final UUID uuid;
    private final Vector location = new Vector();
    private byte lastYaw;
    private Vector lastOffset;
    private final DataWatcher.Item<Byte> commonDataItem;
    private final DataWatcher.Item<Float> cloudRadius;
    private FakeEntity.DisplaySlot display = FakeEntity.DisplaySlot.ZERO;
    private boolean isSmall;

    public FakeAreaEffectCloud(double x, double y, double z) {
        this.entityId = ModelEngineAPI.getEntityHandler().getEntityCounter().incrementAndGet();
        this.uuid = UUID.randomUUID();
        this.location.setX(x).setY(y).setZ(z);
        this.commonDataItem = new DataWatcher.Item(DataAccessors.COMMON_DATA, (Object)32);
        this.cloudRadius = new DataWatcher.Item(DataAccessors.CLOUD_RADIUS, (Object)Float.valueOf(0.0f));
    }

    public PacketPlayOutSpawnEntity spawn() {
        return this.spawn(0.0f);
    }

    public PacketPlayOutSpawnEntity spawn(float yaw) {
        this.updateOffset(TMath.rotToByte(yaw));
        PacketDataSerializer spawn = NetworkUtils.createByteBuf();
        spawn.d(this.entityId);
        spawn.a(this.uuid);
        spawn.d(IRegistry.ENTITY_TYPE.a((Object)EntityTypes.AREA_EFFECT_CLOUD));
        spawn.writeDouble(this.location.getX() + this.lastOffset.getX());
        spawn.writeDouble(this.location.getY() + this.lastOffset.getY() + -0.375);
        spawn.writeDouble(this.location.getZ() + this.lastOffset.getZ());
        spawn.writeByte(0);
        spawn.writeByte(0);
        spawn.writeInt(0);
        spawn.writeShort(0);
        spawn.writeShort(0);
        spawn.writeShort(0);
        return NetworkUtils.writeData(new PacketPlayOutSpawnEntity(), spawn);
    }

    public PacketPlayOutEntityMetadata meta() {
        PacketDataSerializer data = NetworkUtils.createByteBuf();
        data.d(this.entityId);
        NetworkUtils.packMeta(List.of(this.commonDataItem, this.cloudRadius), data);
        return NetworkUtils.writeData(new PacketPlayOutEntityMetadata(), data);
    }

    public PacketPlayOutEntityTeleport updatePosition(Vector vector) {
        return this.updatePosition(0.0f, vector);
    }

    public PacketPlayOutEntityTeleport updatePosition(float yaw, Vector vector) {
        byte byteYaw = TMath.rotToByte(yaw);
        if (TMath.isSimilar(this.location, vector) && this.lastYaw == byteYaw) {
            return null;
        }
        this.updateOffset(byteYaw);
        this.location.zero().add(vector);
        PacketDataSerializer pos = NetworkUtils.createByteBuf();
        pos.d(this.entityId);
        pos.writeDouble(this.location.getX() + this.lastOffset.getX());
        pos.writeDouble(this.location.getY() + this.lastOffset.getY() + -0.375);
        pos.writeDouble(this.location.getZ() + this.lastOffset.getZ());
        pos.writeByte(0);
        pos.writeByte(0);
        pos.writeBoolean(false);
        return NetworkUtils.writeData(new PacketPlayOutEntityTeleport(), pos);
    }

    public PacketPlayOutMount addPassengers(int ... id) {
        PacketDataSerializer mount = NetworkUtils.createByteBuf();
        mount.d(this.entityId);
        mount.a(id);
        return NetworkUtils.writeData(new PacketPlayOutMount(), mount);
    }

    private void updateOffset(byte yaw) {
        if (this.lastYaw == yaw && this.lastOffset != null) {
            return;
        }
        this.lastYaw = yaw;
        this.lastOffset = this.display.getPivotOffset(this.isSmall, TMath.byteToRot(yaw));
    }

    public int getEntityId() {
        return this.entityId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Vector getLocation() {
        return this.location;
    }

    public FakeEntity.DisplaySlot getDisplay() {
        return this.display;
    }

    public void setDisplay(FakeEntity.DisplaySlot display) {
        this.display = display;
    }

    public boolean isSmall() {
        return this.isSmall;
    }

    public void setSmall(boolean isSmall) {
        this.isSmall = isSmall;
    }
}

