/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.entity.controller.special;

import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.nms.v1_16_R3.entity.controller.MoveControlWrapper;
import net.minecraft.server.v1_16_R3.ControllerMove;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityVex;
import net.minecraft.server.v1_16_R3.Vec3D;

public class VexMoveControlWrapper
extends MoveControlWrapper {
    private final EntityVex vex;

    public VexMoveControlWrapper(EntityVex a, ControllerMove control, ModeledEntity model) {
        super((EntityInsentient)a, control, model);
        this.vex = a;
    }

    @Override
    protected void defaultTick() {
        ControllerMove.Operation operation = this.getOperation();
        switch (operation) {
            case WAIT: {
                this.modeledEntity.setState(ModelState.IDLE);
                break;
            }
            case MOVE_TO: 
            case STRAFE: {
                this.modeledEntity.setState(ModelState.WALK);
                break;
            }
            case JUMPING: {
                this.modeledEntity.setState(ModelState.JUMP);
            }
        }
        if (operation == ControllerMove.Operation.MOVE_TO) {
            Vec3D delta = new Vec3D(this.d() - this.vex.locX(), this.e() - this.vex.locY(), this.f() - this.vex.locZ());
            double distance = delta.f();
            boolean distanceCheck = distance < this.vex.getBoundingBox().a();
            boolean isCharging = this.vex.isCharging();
            boolean isWantedWithinHitbox = this.vex.getBoundingBox().e(this.d(), this.e(), this.f());
            if (distanceCheck && (!isCharging || isWantedWithinHitbox)) {
                operation = ControllerMove.Operation.WAIT;
                this.vex.setMot(this.vex.getMot().a(0.5));
            } else {
                this.vex.setMot(this.vex.getMot().e(delta.a(this.c() * 0.05 / distance)));
                if (this.vex.getGoalTarget() == null) {
                    Vec3D vec3d1 = this.vex.getMot();
                    this.vex.yaw = (float)TMath.fastAtan2(-vec3d1.x, vec3d1.z) * 57.295776f;
                } else {
                    double dX = this.vex.getGoalTarget().locX() - this.vex.locX();
                    double dZ = this.vex.getGoalTarget().locZ() - this.vex.locZ();
                    this.vex.yaw = (float)TMath.fastAtan2(-dX, dZ) * 57.295776f;
                }
                this.vex.aA = this.vex.yaw;
            }
        }
        this.setOperation(operation);
    }
}

