/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.entity.controller;

import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.Mountable;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.utils.FieldUtils;
import com.ticxo.modelengine.nms.v1_16_R3.NMSFields;
import java.lang.reflect.Field;
import net.minecraft.server.v1_16_R3.ControllerMove;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.PlayerConnection;
import net.minecraft.server.v1_16_R3.Vec3D;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class MoveControlWrapper
extends ControllerMove
implements MoveController {
    private static final Field operationField = FieldUtils.getField(ControllerMove.class, NMSFields.MOVECONTROL_operation);
    protected final ModeledEntity modeledEntity;
    protected final MountManager mountManager;
    protected final ControllerMove original;
    protected ControllerMove.Operation operation;
    protected boolean isOnGround;

    public MoveControlWrapper(EntityInsentient a, ControllerMove control, ModeledEntity model) {
        super(a);
        this.original = control;
        this.modeledEntity = model;
        this.mountManager = model.getMountManager();
        this.operation = ControllerMove.Operation.WAIT;
    }

    public boolean b() {
        return this.original.b();
    }

    public double c() {
        return this.original.c();
    }

    public void a(double var0, double var2, double var4, double var6) {
        this.original.a(var0, var2, var4, var6);
        if (this.operation != ControllerMove.Operation.JUMPING) {
            this.operation = ControllerMove.Operation.MOVE_TO;
        }
    }

    public void a(float var0, float var1) {
        this.original.a(var0, var1);
        this.operation = ControllerMove.Operation.STRAFE;
    }

    public void a() {
        this.isOnGround = this.a.isOnGround();
        if (this.mountManager != null && this.mountManager.isControlled()) {
            this.a.setOnGround(true);
            this.controlledTick();
        } else {
            this.defaultTick();
        }
        if (this.mountManager != null) {
            this.passengerTick();
        }
    }

    protected void controlledTick() {
        this.a.t(0.0f);
        this.a.v(0.0f);
        MountController controller = this.mountManager.getDriverController();
        if (controller == null) {
            return;
        }
        if (controller.getInput() == null) {
            controller.setInput(new MountController.MountInput());
        }
        controller.updateDriverMovement(this, this.modeledEntity);
        controller.updateRiderPosition(this, this.mountManager.getDriverBone());
    }

    protected void defaultTick() {
        switch (this.operation) {
            case WAIT: {
                this.modeledEntity.setState(ModelState.IDLE);
                break;
            }
            case MOVE_TO: 
            case STRAFE: {
                this.modeledEntity.setState(ModelState.WALK);
                break;
            }
            case JUMPING: {
                this.modeledEntity.setState(ModelState.JUMP);
            }
        }
        this.original.a();
        switch (this.operation) {
            case STRAFE: {
                this.operation = ControllerMove.Operation.WAIT;
                break;
            }
            case MOVE_TO: {
                try {
                    this.operation = (ControllerMove.Operation)operationField.get(this.original);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                break;
            }
            case JUMPING: {
                if (!this.a.isOnGround()) break;
                this.operation = ControllerMove.Operation.WAIT;
            }
        }
    }

    protected void passengerTick() {
        if (!this.mountManager.hasPassengers()) {
            return;
        }
        for (Entity entity : this.mountManager.getPassengers().keySet()) {
            Mountable mountable = this.mountManager.getPassengers().get(entity);
            MountController controller = this.mountManager.getController(entity.getUniqueId());
            if (controller == null) continue;
            if (controller.getInput() == null) {
                controller.setInput(new MountController.MountInput());
            }
            controller.updatePassengerMovement(this, this.modeledEntity);
            controller.updateRiderPosition(this, mountable);
        }
    }

    protected void setOperation(ControllerMove.Operation operation) {
        try {
            operationField.set(this.original, operation);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.operation = operation;
    }

    protected ControllerMove.Operation getOperation() {
        try {
            return (ControllerMove.Operation)operationField.get(this.original);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return ControllerMove.Operation.WAIT;
        }
    }

    public double d() {
        return this.original.d();
    }

    public double e() {
        return this.original.e();
    }

    public double f() {
        return this.original.f();
    }

    @Override
    public void move(float side, float front, float speedModifier) {
        float speed = this.getSpeed();
        this.a.q(speed * speedModifier);
        this.a.t(front);
        this.a.v(side);
    }

    @Override
    public void jump() {
        this.a.getControllerJump().jump();
    }

    @Override
    public void setVelocity(double x, double y, double z) {
        this.a.setMot(x, y, z);
    }

    @Override
    public void addVelocity(double x, double y, double z) {
        this.a.setMot(this.a.getMot().add(x, y, z));
    }

    @Override
    public void nullifyFallDistance() {
        this.a.fallDistance = 0.0f;
    }

    @Override
    public void movePassenger(Entity entity, double x, double y, double z) {
        net.minecraft.server.v1_16_R3.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        double seatY = y + nmsEntity.bb();
        nmsEntity.setPosition(x, seatY, z);
        nmsEntity.setMot(Vec3D.ORIGIN);
        this.a.fallDistance = 0.0f;
        if (nmsEntity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)nmsEntity;
            try {
                FieldUtils.getField(PlayerConnection.class, NMSFields.SERVERGAMEPACKETLISTENERIMPL_clientIsFloating).setBoolean(player.playerConnection, false);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isOnGround() {
        return this.isOnGround;
    }

    @Override
    public float getSpeed() {
        return (float)this.a.craftAttributes.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getBaseValue();
    }

    @Override
    public Vector getVelocity() {
        return CraftVector.toBukkit((Vec3D)this.a.getMot());
    }
}

