/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.entity.controller;

import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.utils.math.TMath;
import net.minecraft.server.v1_16_R3.EntityAIBodyControl;
import net.minecraft.server.v1_16_R3.EntityInsentient;

@CommandAccessible(value={BodyRotationController.class})
public class BodyRotationControlWrapper
extends EntityAIBodyControl
implements BodyRotationController {
    private final EntityInsentient mob;
    private boolean isHeadClampUneven;
    private boolean isBodyClampUneven;
    private float maxHeadAngle;
    private float maxBodyAngle;
    private float minHeadAngle;
    private float minBodyAngle;
    private boolean playerMode;
    private float stableAngle = 15.0f;
    private int rotationDelay = 10;
    private int rotationDuration = 10;
    private int headStableTime;
    private float lastStableYHeadRot;

    public BodyRotationControlWrapper(EntityInsentient mob) {
        super(mob);
        this.mob = mob;
        this.maxHeadAngle = mob.Q();
        this.maxBodyAngle = mob.Q();
        this.minHeadAngle = -this.maxHeadAngle;
        this.minBodyAngle = -this.minBodyAngle;
    }

    public void a() {
        if (this.isMoving()) {
            this.mob.aA = this.mob.yaw;
            this.rotateHeadIfNecessary();
            this.lastStableYHeadRot = this.mob.aC;
            this.headStableTime = 0;
        } else if (this.notCarryingEntityInsentientPassengers()) {
            if (Math.abs(this.mob.aC - this.lastStableYHeadRot) > this.stableAngle) {
                this.headStableTime = 0;
                this.lastStableYHeadRot = this.mob.aC;
                this.rotateBodyIfNecessary();
            } else if (!this.playerMode) {
                ++this.headStableTime;
                if (this.headStableTime > this.rotationDelay) {
                    this.rotateHeadTowardsFront();
                }
            }
        }
    }

    @Override
    public void setYHeadRot(float rot) {
        this.mob.aC = rot;
    }

    @Override
    public float getYHeadRot() {
        return this.mob.aC;
    }

    @Override
    public float getXHeadRot() {
        return this.mob.pitch;
    }

    @Override
    public void setYBodyRot(float rot) {
        this.mob.aA = rot;
    }

    @Override
    public float getYBodyRot() {
        return this.mob.aA;
    }

    private void rotateBodyIfNecessary() {
        this.mob.aA = TMath.rotateIfNecessary(this.mob.aA, this.mob.aC, this.isBodyClampUneven ? this.minBodyAngle : -this.maxBodyAngle, this.maxBodyAngle);
    }

    private void rotateHeadIfNecessary() {
        this.mob.aC = TMath.rotateIfNecessary(this.mob.aC, this.mob.aA, this.isHeadClampUneven ? this.minHeadAngle : -this.maxHeadAngle, this.maxHeadAngle);
    }

    private void rotateHeadTowardsFront() {
        float ratio = (float)(this.headStableTime - this.rotationDelay) / (float)this.rotationDuration;
        float clampedRatio = TMath.clamp(ratio, 0.0f, 1.0f);
        float maxClamp = this.maxHeadAngle * (1.0f - clampedRatio);
        float minClamp = (this.isHeadClampUneven ? this.minHeadAngle : -this.maxHeadAngle) * (1.0f - clampedRatio);
        this.mob.aA = TMath.rotateIfNecessary(this.mob.aA, this.mob.aC, minClamp, maxClamp);
    }

    private boolean notCarryingEntityInsentientPassengers() {
        return this.mob.getPassengers().isEmpty() || !(this.mob.getPassengers().get(0) instanceof EntityInsentient);
    }

    private boolean isMoving() {
        double dZ;
        double dX = this.mob.locX() - this.mob.lastX;
        return dX * dX + (dZ = this.mob.locZ() - this.mob.lastZ) * dZ > 2.500000277905201E-7;
    }

    @Override
    public boolean isHeadClampUneven() {
        return this.isHeadClampUneven;
    }

    @Override
    public void setHeadClampUneven(boolean isHeadClampUneven) {
        this.isHeadClampUneven = isHeadClampUneven;
    }

    @Override
    public boolean isBodyClampUneven() {
        return this.isBodyClampUneven;
    }

    @Override
    public void setBodyClampUneven(boolean isBodyClampUneven) {
        this.isBodyClampUneven = isBodyClampUneven;
    }

    @Override
    public float getMaxHeadAngle() {
        return this.maxHeadAngle;
    }

    @Override
    public void setMaxHeadAngle(float maxHeadAngle) {
        this.maxHeadAngle = maxHeadAngle;
    }

    @Override
    public float getMaxBodyAngle() {
        return this.maxBodyAngle;
    }

    @Override
    public void setMaxBodyAngle(float maxBodyAngle) {
        this.maxBodyAngle = maxBodyAngle;
    }

    @Override
    public float getMinHeadAngle() {
        return this.minHeadAngle;
    }

    @Override
    public void setMinHeadAngle(float minHeadAngle) {
        this.minHeadAngle = minHeadAngle;
    }

    @Override
    public float getMinBodyAngle() {
        return this.minBodyAngle;
    }

    @Override
    public void setMinBodyAngle(float minBodyAngle) {
        this.minBodyAngle = minBodyAngle;
    }

    @Override
    public boolean isPlayerMode() {
        return this.playerMode;
    }

    @Override
    public void setPlayerMode(boolean playerMode) {
        this.playerMode = playerMode;
    }

    @Override
    public float getStableAngle() {
        return this.stableAngle;
    }

    @Override
    public void setStableAngle(float stableAngle) {
        this.stableAngle = stableAngle;
    }

    @Override
    public int getRotationDelay() {
        return this.rotationDelay;
    }

    @Override
    public void setRotationDelay(int rotationDelay) {
        this.rotationDelay = rotationDelay;
    }

    @Override
    public int getRotationDuration() {
        return this.rotationDuration;
    }

    @Override
    public void setRotationDuration(int rotationDuration) {
        this.rotationDuration = rotationDuration;
    }
}

