/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.targeters;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.skills.targeters.IEntityTargeter;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.entity.Entity;

public class TargeterModelPassengers
implements IEntityTargeter {
    private final PlaceholderString modelId;
    private final PlaceholderString pbone;

    public TargeterModelPassengers(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.pbone = mlc.getPlaceholderString(new String[]{"p", "pbone, seat"}, null, new String[0]);
    }

    public Collection<AbstractEntity> getEntities(SkillMetadata skillMetadata) {
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        SkillCaster caster = skillMetadata.getCaster();
        ModeledEntity model = ModelEngineAPI.getModeledEntity(caster.getEntity().getUniqueId());
        if (model == null) {
            return targets;
        }
        String parts = MythicUtils.getOrNull(this.pbone, (PlaceholderMeta)skillMetadata);
        if (parts == null) {
            return targets;
        }
        String[] seats = parts.split(",");
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata);
        MountManager handler = model.getMountManager();
        if (modelId == null) {
            for (String id : model.getModels().keySet()) {
                for (String seat : seats) {
                    for (Entity rider : handler.getPassengersOnSeat(id, seat)) {
                        targets.add(BukkitAdapter.adapt((Entity)rider));
                    }
                }
            }
        } else {
            for (String seat : seats) {
                for (Entity rider : handler.getPassengersOnSeat(modelId, seat)) {
                    targets.add(BukkitAdapter.adapt((Entity)rider));
                }
            }
        }
        return targets;
    }
}

