/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.targeters;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.utils.math.Offset;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.skills.targeters.ILocationTargeter;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class TargeterModelPart
implements ILocationTargeter {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final PlaceholderString offset;
    private final PlaceholderDouble x;
    private final PlaceholderDouble y;
    private final PlaceholderDouble z;
    private final boolean exactMatch;
    private String part;
    private Mode offsetMode;
    private double oX;
    private double oY;
    private double oZ;
    private World world;

    public TargeterModelPart(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mlc.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
        this.offset = mlc.getPlaceholderString(new String[]{"o", "off", "offset"}, "LOCAL", new String[0]);
        this.x = mlc.getPlaceholderDouble("x", 0.0);
        this.y = mlc.getPlaceholderDouble("y", 0.0);
        this.z = mlc.getPlaceholderDouble("z", 0.0);
        this.exactMatch = mlc.getBoolean(new String[]{"em", "exact", "match", "exactmatch"}, true);
    }

    public Collection<AbstractLocation> getLocations(SkillMetadata skillMetadata) {
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        SkillCaster caster = skillMetadata.getCaster();
        ModeledEntity model = ModelEngineAPI.getModeledEntity(caster.getEntity().getUniqueId());
        if (model == null) {
            return targets;
        }
        this.part = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata);
        if (this.part == null) {
            return targets;
        }
        this.offsetMode = Mode.get(this.offset.get((PlaceholderMeta)skillMetadata).toUpperCase(Locale.ENGLISH));
        this.oX = this.x.get((PlaceholderMeta)skillMetadata);
        this.oY = this.y.get((PlaceholderMeta)skillMetadata);
        this.oZ = this.z.get((PlaceholderMeta)skillMetadata);
        this.world = model.getBase().getWorld();
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata);
        MythicUtils.executeOptModelId(model, modelId, activeModel -> this.searchModel((ActiveModel)activeModel, targets));
        return targets;
    }

    private void searchModel(ActiveModel activeModel, HashSet<AbstractLocation> targets) {
        if (activeModel == null) {
            return;
        }
        if (this.exactMatch) {
            ModelBone bone = activeModel.getBoneIndex().get(this.part);
            if (bone != null) {
                this.searchBone(bone, targets);
            }
            return;
        }
        for (String id : activeModel.getBoneIndex().keySet()) {
            if (!id.contains(this.part)) continue;
            ModelBone bone = activeModel.getBoneIndex().get(id);
            this.searchBone(bone, targets);
        }
    }

    private void searchBone(ModelBone bone, HashSet<AbstractLocation> targets) {
        Vector boneLocation = bone.getPosition().clone();
        targets.add(switch (this.offsetMode) {
            case Mode.LOCAL -> {
                Vector offset = new Vector(this.oX, this.oY, this.oZ);
                Offset.getRelativeLocation(bone.getRotation(), offset);
                Offset.rotateYaw(offset, Math.toRadians(bone.getYaw()));
                yield BukkitAdapter.adapt((Location)boneLocation.toLocation(this.world).add(offset));
            }
            case Mode.MODEL -> {
                Vector offset = new Vector(this.oX, this.oY, this.oZ);
                Offset.rotateYaw(offset, Math.toRadians(bone.getYaw()));
                yield BukkitAdapter.adapt((Location)boneLocation.toLocation(this.world).add(offset));
            }
            case Mode.GLOBAL -> BukkitAdapter.adapt((Location)boneLocation.toLocation(this.world).add(this.oX, this.oY, this.oZ));
            default -> throw new IllegalStateException();
        });
    }

    private static enum Mode {
        LOCAL,
        MODEL,
        GLOBAL;


        public static Mode get(String name) {
            try {
                return Mode.valueOf(name);
            }
            catch (IllegalArgumentException ignored) {
                return LOCAL;
            }
        }
    }
}

