/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.UUID;

public class MechanicVFXUpdateRotation
implements ITargetedEntitySkill,
INoTargetSkill {
    private final PlaceholderString angle;
    private final boolean newOrigin;

    public MechanicVFXUpdateRotation(MythicLineConfig mlc) {
        this.angle = mlc.getPlaceholderString(new String[]{"angle", "a"}, null, new String[0]);
        this.newOrigin = mlc.getBoolean(new String[]{"neworigin", "origin", "o"}, false);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        VFX vfx = ModelEngineAPI.getVFXTicker().getVFX(target.getUniqueId());
        if (vfx == null || vfx.isAutoTick()) {
            return SkillResult.CONDITION_FAILED;
        }
        String angle = MythicUtils.getOrNull(this.angle, (PlaceholderMeta)meta);
        if (angle == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String[] split = angle.split(",");
        double x = Double.parseDouble(split[0]);
        double y = Double.parseDouble(split[1]);
        double z = Double.parseDouble(split[2]);
        vfx.rotate(TMath.makeAngle(x, y, z), this.newOrigin);
        return SkillResult.SUCCESS;
    }

    public SkillResult cast(SkillMetadata meta) {
        UUID uuid = MythicUtils.getVFXUniqueId(meta);
        VFX vfx = ModelEngineAPI.getVFXTicker().getVFX(uuid);
        if (vfx == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String angle = MythicUtils.getOrNull(this.angle, (PlaceholderMeta)meta);
        if (angle == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String[] split = angle.split(",");
        double x = Double.parseDouble(split[0]);
        double y = Double.parseDouble(split[1]);
        double z = Double.parseDouble(split[2]);
        vfx.rotate(TMath.makeAngle(x, y, z), this.newOrigin);
        return SkillResult.SUCCESS;
    }
}

