/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import java.util.UUID;

public class MechanicVFXUpdatePosition
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private final boolean noRot;

    public MechanicVFXUpdatePosition(MythicLineConfig mlc) {
        this.noRot = mlc.getBoolean(new String[]{"i", "ir", "ignore", "ignorerotation"}, false);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        return this.castAtLocation(meta, target.getLocation());
    }

    public SkillResult castAtLocation(SkillMetadata meta, AbstractLocation target) {
        UUID uuid = MythicUtils.getVFXUniqueId(meta);
        VFX vfx = ModelEngineAPI.getVFXTicker().getVFX(uuid);
        if (vfx == null || vfx.isAutoTick()) {
            return SkillResult.CONDITION_FAILED;
        }
        vfx.setPosition(target.toPosition().toVector());
        if (!this.noRot) {
            vfx.setYaw(target.getYaw());
        }
        return SkillResult.SUCCESS;
    }
}

