/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import java.util.UUID;
import org.bukkit.entity.Player;

public class MechanicVFXSetObservers
implements ITargetedEntitySkill {
    private final boolean remove;
    private final boolean force;

    public MechanicVFXSetObservers(MythicLineConfig mlc) {
        this.remove = mlc.getBoolean(new String[]{"r", "remove"}, false);
        this.force = mlc.getBoolean(new String[]{"f", "force"}, false);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        UUID uuid = MythicUtils.getVFXUniqueId(meta);
        VFX vfx = ModelEngineAPI.getVFXTicker().getVFX(uuid);
        if (vfx == null) {
            return SkillResult.CONDITION_FAILED;
        }
        if (this.remove) {
            vfx.getRangeManager().removePlayer((Player)target.getBukkitEntity());
        } else if (this.force) {
            vfx.getRangeManager().forceSpawn((Player)target.getBukkitEntity());
        } else {
            vfx.getRangeManager().updatePlayer((Player)target.getBukkitEntity());
        }
        return SkillResult.SUCCESS;
    }

    public boolean getTargetsCreatives() {
        return true;
    }
}

