/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import java.util.UUID;

public class MechanicVFXPoint
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private final boolean lockRoll;

    public MechanicVFXPoint(MythicLineConfig mlc) {
        this.lockRoll = mlc.getBoolean(new String[]{"ov", "over", "overwrite"}, false);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        return this.castAtLocation(meta, target.getLocation());
    }

    public SkillResult castAtLocation(SkillMetadata meta, AbstractLocation target) {
        UUID uuid = MythicUtils.getVFXUniqueId(meta);
        VFX vfx = ModelEngineAPI.getVFXTicker().getVFX(uuid);
        if (vfx == null || vfx.isAutoTick()) {
            return SkillResult.CONDITION_FAILED;
        }
        vfx.point(target.toPosition().toVector(), this.lockRoll);
        return SkillResult.SUCCESS;
    }
}

