/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import java.util.UUID;

public class MechanicVFXEnchant
implements ITargetedEntitySkill,
INoTargetSkill {
    private final boolean enchant;

    public MechanicVFXEnchant(MythicLineConfig mlc) {
        this.enchant = mlc.getBoolean(new String[]{"e", "en", "enchant"}, true);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        VFX vfx = ModelEngineAPI.getVFXTicker().getVFX(target.getUniqueId());
        if (vfx == null) {
            return SkillResult.CONDITION_FAILED;
        }
        vfx.setEnchant(this.enchant);
        return SkillResult.SUCCESS;
    }

    public SkillResult cast(SkillMetadata meta) {
        UUID uuid = MythicUtils.getVFXUniqueId(meta);
        VFX vfx = ModelEngineAPI.getVFXTicker().getVFX(uuid);
        if (vfx == null) {
            return SkillResult.CONDITION_FAILED;
        }
        vfx.setEnchant(this.enchant);
        return SkillResult.SUCCESS;
    }
}

