/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.UUID;

public class MechanicVFXCopyRotation
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;

    public MechanicVFXCopyRotation(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mlc.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, "", new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        ActiveModel activeMob = MythicUtils.getActiveModelOrNull(model, MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target));
        if (activeMob == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String partId = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)meta, target);
        ModelBone bone = activeMob.getBoneIndex().get(partId);
        if (bone == null) {
            return SkillResult.INVALID_CONFIG;
        }
        UUID uuid = MythicUtils.getVFXUniqueId(meta);
        VFX vfx = ModelEngineAPI.getVFXTicker().getVFX(uuid);
        if (vfx == null || vfx.isAutoTick()) {
            return SkillResult.CONDITION_FAILED;
        }
        vfx.setRotation(bone.getRotation());
        return SkillResult.SUCCESS;
    }
}

