/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.UUID;

public class MechanicVFXChangeModel
implements ITargetedEntitySkill,
INoTargetSkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;

    public MechanicVFXChangeModel(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mlc.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        String partId = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)meta, target);
        if (modelId == null || partId == null) {
            return SkillResult.INVALID_CONFIG;
        }
        VFX vfx = ModelEngineAPI.getVFXTicker().getVFX(target.getUniqueId());
        if (vfx == null) {
            return SkillResult.CONDITION_FAILED;
        }
        vfx.useModel(modelId, partId);
        return SkillResult.SUCCESS;
    }

    public SkillResult cast(SkillMetadata meta) {
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta);
        String partId = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)meta);
        if (modelId == null || partId == null) {
            return SkillResult.INVALID_CONFIG;
        }
        UUID uuid = MythicUtils.getVFXUniqueId(meta);
        VFX vfx = ModelEngineAPI.getVFXTicker().getVFX(uuid);
        if (vfx == null) {
            return SkillResult.CONDITION_FAILED;
        }
        vfx.useModel(modelId, partId);
        return SkillResult.SUCCESS;
    }
}

