/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.mythic.MythicUtils;
import com.ticxo.modelengine.mythic.compatibility.ProjectileEntity;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import java.util.UUID;
import org.bukkit.Color;

public class MechanicVFX
implements ITargetedEntitySkill,
INoTargetSkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final boolean remove;
    private final PlaceholderInt radius;
    private final PlaceholderString color;
    private final boolean enchant;
    private final boolean visible;
    private final boolean baseVisible;
    private final boolean autoTick;
    private final boolean autoRange;

    public MechanicVFX(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mlc.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
        this.remove = mlc.getBoolean(new String[]{"r", "remove"}, false);
        this.radius = mlc.getPlaceholderInteger(new String[]{"rad", "radius"}, 0, new String[0]);
        this.color = mlc.getPlaceholderString(new String[]{"c", "color"}, "FFFFFF", new String[0]);
        this.enchant = mlc.getBoolean(new String[]{"en", "enchant"}, false);
        this.visible = mlc.getBoolean(new String[]{"v", "visible"}, true);
        this.baseVisible = mlc.getBoolean(new String[]{"bv", "bvisible"}, false);
        this.autoTick = mlc.getBoolean(new String[]{"at", "autotick"}, false);
        this.autoRange = mlc.getBoolean(new String[]{"ar", "autorange"}, true);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        if (this.remove) {
            VFX vfx = ModelEngineAPI.getVFXTicker().getVFX(target.getUniqueId());
            if (vfx == null) {
                return SkillResult.CONDITION_FAILED;
            }
            vfx.destroy();
            return SkillResult.SUCCESS;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        String partId = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)meta, target);
        if (modelId == null || partId == null) {
            return SkillResult.INVALID_CONFIG;
        }
        int radius = this.radius.get((PlaceholderMeta)meta, target);
        Color color = MythicUtils.getColor(MythicUtils.getOrNull(this.color, (PlaceholderMeta)meta, target));
        VFX vfx = ModelEngineAPI.createVFX(target.getBukkitEntity());
        vfx.useModel(modelId, partId);
        if (radius > 0) {
            vfx.getRangeManager().setRenderDistance(radius);
        }
        vfx.setColor(color);
        vfx.setEnchant(this.enchant);
        vfx.setAutoTick(this.autoTick);
        vfx.setVisible(this.visible);
        vfx.setBaseEntityVisible(this.baseVisible);
        vfx.create();
        return SkillResult.SUCCESS;
    }

    public SkillResult cast(SkillMetadata meta) {
        IParentSkill iParentSkill = meta.getCallingEvent();
        if (!(iParentSkill instanceof Projectile.ProjectileTracker)) {
            return SkillResult.INVALID_TARGET;
        }
        Projectile.ProjectileTracker projectileTracker = (Projectile.ProjectileTracker)iParentSkill;
        if (this.remove) {
            UUID uuid = MythicUtils.getVFXUniqueId(meta);
            VFX vfx = ModelEngineAPI.getVFXTicker().getVFX(uuid);
            if (vfx == null) {
                return SkillResult.CONDITION_FAILED;
            }
            vfx.destroy();
            return SkillResult.SUCCESS;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta);
        String partId = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)meta);
        if (modelId == null || partId == null) {
            return SkillResult.INVALID_CONFIG;
        }
        int radius = this.radius.get((PlaceholderMeta)meta);
        Color color = MythicUtils.getColor(MythicUtils.getOrNull(this.color, (PlaceholderMeta)meta));
        ProjectileEntity projEntity = new ProjectileEntity(projectileTracker, this.autoRange);
        VFX vfx = ModelEngineAPI.createVFX(projEntity);
        vfx.useModel(modelId, partId);
        vfx.getRangeManager().setRenderDistance(radius);
        vfx.setColor(color);
        vfx.setEnchant(this.enchant);
        vfx.setAutoTick(this.autoTick);
        vfx.setVisible(this.visible);
        vfx.setBaseEntityVisible(this.baseVisible);
        vfx.create();
        return SkillResult.SUCCESS;
    }

    public ThreadSafetyLevel getThreadSafetyLevel() {
        return this.autoRange ? ThreadSafetyLevel.SYNC_ONLY : ThreadSafetyLevel.EITHER;
    }
}

