/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicSwapModel
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString newModelId;

    public MechanicSwapModel(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.newModelId = mlc.getPlaceholderString(new String[]{"n", "nid", "newmodel", "newmodelid"}, null, new String[0]);
        TLogger.warn("The SwapModel mechanic would be deprecated very soon. Please use the Model mechanic.");
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        if (modelId == null || model.getModel(modelId) == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String newModelId = MythicUtils.getOrNull(this.newModelId, (PlaceholderMeta)meta, target);
        ModelBlueprint blueprint = MythicUtils.getBlueprintOrNull(newModelId);
        if (blueprint == null) {
            return SkillResult.INVALID_CONFIG;
        }
        ActiveModel oldModel = model.removeModel(modelId);
        ActiveModel newModel = ModelEngineAPI.createActiveModel(blueprint);
        newModel.setLockPitch(oldModel.isLockPitch());
        newModel.setLockYaw(oldModel.isLockYaw());
        newModel.setCanHurt(oldModel.isCanHurt());
        oldModel.destroy();
        model.addModel(newModel, true);
        return SkillResult.SUCCESS;
    }
}

