/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicSwapEntity
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final boolean hitbox;
    private final boolean invisible;
    private final PlaceholderDouble stepHeight;
    private final PlaceholderInt viewRadius;

    public MechanicSwapEntity(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.hitbox = mlc.getBoolean(new String[]{"h", "hitbox"}, true);
        this.invisible = mlc.getBoolean(new String[]{"i", "invis", "invisible"}, true);
        this.stepHeight = mlc.getPlaceholderDouble(new String[]{"s", "step"}, 0.5, new String[0]);
        this.viewRadius = mlc.getPlaceholderInteger(new String[]{"rad", "radius"}, 0, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        AbstractEntity caster = meta.getCaster().getEntity();
        ModeledEntity casterModel = ModelEngineAPI.getModeledEntity(caster.getUniqueId());
        if (casterModel == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String modelId = this.modelId.get((PlaceholderMeta)meta, target);
        if (modelId == null) {
            return SkillResult.INVALID_CONFIG;
        }
        if (casterModel.getModel(modelId) == null) {
            return SkillResult.INVALID_CONFIG;
        }
        ModeledEntity targetModel = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (targetModel == null) {
            targetModel = ModelEngineAPI.createModeledEntity(target.getBukkitEntity());
        } else if (targetModel.getModel(modelId) != null) {
            return SkillResult.CONDITION_FAILED;
        }
        ActiveModel activeModel = casterModel.removeModel(modelId);
        activeModel.setSwappable(true);
        if (casterModel.getModels().isEmpty()) {
            casterModel.setBaseEntityVisible(true);
            ModelEngineAPI.removeModeledEntity(caster.getUniqueId());
        }
        double stepHeight = this.stepHeight.get((PlaceholderMeta)meta, target);
        int viewRadius = this.viewRadius.get((PlaceholderMeta)meta, target);
        targetModel.setBaseEntityVisible(!this.invisible);
        targetModel.setStepHeight(stepHeight);
        if (viewRadius > 0) {
            targetModel.getRangeManager().setRenderDistance(viewRadius);
        }
        targetModel.addModel(activeModel, this.hitbox);
        return SkillResult.SUCCESS;
    }
}

