/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicSubModel
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString parentId;
    private final PlaceholderString childId;
    private final boolean remove;

    public MechanicSubModel(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.parentId = mlc.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
        this.childId = mlc.getPlaceholderString(new String[]{"sp", "spid", "subpart", "subpartid"}, null, new String[0]);
        this.remove = mlc.getBoolean(new String[]{"r", "remove"}, false);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(model, modelId);
        if (activeModel == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String parentId = MythicUtils.getOrNull(this.parentId, (PlaceholderMeta)meta, target);
        String childId = MythicUtils.getOrNull(this.childId, (PlaceholderMeta)meta, target);
        if (this.remove) {
            if (childId == null) {
                return SkillResult.INVALID_CONFIG;
            }
            activeModel.removeBone(childId);
        } else {
            if (parentId == null || childId == null) {
                return SkillResult.INVALID_CONFIG;
            }
            BlueprintBone childBone = activeModel.getBlueprint().getFlatMap().get(childId);
            if (childBone == null) {
                return SkillResult.INVALID_CONFIG;
            }
            activeModel.forceGenerateBone(parentId, childBone);
        }
        return SkillResult.SUCCESS;
    }
}

