/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.AnimationHandler;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicState
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString state;
    private final boolean remove;
    private final boolean ignoreLerp;
    private final boolean force;
    private final PlaceholderInt lerpIn;
    private final PlaceholderInt lerpOut;
    private final PlaceholderDouble speed;

    public MechanicState(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.state = mlc.getPlaceholderString(new String[]{"s", "state"}, null, new String[0]);
        this.remove = mlc.getBoolean(new String[]{"r", "remove"}, false);
        this.speed = mlc.getPlaceholderDouble(new String[]{"sp", "speed"}, 1.0, new String[0]);
        this.lerpIn = mlc.getPlaceholderInteger(new String[]{"li", "lerpin"}, 0, new String[0]);
        this.lerpOut = mlc.getPlaceholderInteger(new String[]{"lo", "lerpout"}, 0, new String[0]);
        this.ignoreLerp = mlc.getBoolean(new String[]{"i", "ignorelerp"}, false);
        this.force = mlc.getBoolean(new String[]{"f", "force"}, true);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        if (this.remove) {
            return this.removeAnimation(meta, target);
        }
        return this.addAnimation(meta, target);
    }

    private SkillResult removeAnimation(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String state = MythicUtils.getOrNull(this.state, (PlaceholderMeta)meta, target);
        if (state == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        MythicUtils.executeOptModelId(model, modelId, activeModel -> this.removeAnimation((ActiveModel)activeModel, state));
        return SkillResult.SUCCESS;
    }

    private void removeAnimation(ActiveModel activeModel, String state) {
        AnimationHandler handler = activeModel.getAnimationHandler();
        if (this.ignoreLerp) {
            handler.forceStopAnimation(state);
        } else {
            handler.stopAnimation(state);
        }
    }

    private SkillResult addAnimation(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String state = MythicUtils.getOrNull(this.state, (PlaceholderMeta)meta, target);
        if (state == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        MythicUtils.executeOptModelId(model, modelId, activeModel -> this.addAnimation((ActiveModel)activeModel, state, meta, target));
        return SkillResult.SUCCESS;
    }

    private void addAnimation(ActiveModel activeModel, String state, SkillMetadata meta, AbstractEntity target) {
        AnimationHandler handler = activeModel.getAnimationHandler();
        int lerpIn = this.lerpIn.get((PlaceholderMeta)meta, target);
        int lerpOut = this.lerpOut.get((PlaceholderMeta)meta, target);
        double speed = this.speed.get((PlaceholderMeta)meta, target);
        handler.playAnimation(state, (double)lerpIn / 20.0, (double)lerpOut / 20.0, speed, this.force);
    }
}

