/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ItemHolder;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MechanicSetItemModel
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final PlaceholderString item;

    public MechanicSetItemModel(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mlc.getPlaceholderString(new String[]{"b", "bone"}, null, new String[0]);
        this.item = mlc.getPlaceholderString(new String[]{"i", "item"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(model, modelId);
        if (activeModel == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String partId = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)meta, target);
        if (partId == null) {
            return SkillResult.INVALID_CONFIG;
        }
        ItemHolder bone = (ItemHolder)activeModel.getItemHolderHandler().getBones().get(partId);
        if (bone == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String item = MythicUtils.getOrNull(this.item, (PlaceholderMeta)meta, target);
        if (item == null) {
            bone.setItemStack(new ItemStack(Material.AIR));
            return SkillResult.SUCCESS;
        }
        Optional maybeMMItem = MythicBukkit.inst().getItemManager().getItem(item);
        if (maybeMMItem.isPresent()) {
            bone.setItemStack(BukkitAdapter.adapt((AbstractItemStack)((MythicItem)maybeMMItem.get()).generateItemStack(1)));
            return SkillResult.SUCCESS;
        }
        Material mat = Material.getMaterial((String)item.toUpperCase(Locale.ENGLISH));
        if (mat == null) {
            return SkillResult.INVALID_CONFIG;
        }
        bone.setItemStack(new ItemStack(mat));
        return SkillResult.SUCCESS;
    }
}

