/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.handler.RendererHandler;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Set;

public class MechanicRemapModel
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString newModelId;
    private final PlaceholderString map;

    public MechanicRemapModel(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.newModelId = mlc.getPlaceholderString(new String[]{"n", "nid", "newmodel", "newmodelid"}, null, new String[0]);
        this.map = mlc.getPlaceholderString(new String[]{"map"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(model, modelId);
        if (activeModel == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String newModelId = MythicUtils.getOrNull(this.newModelId, (PlaceholderMeta)meta, target);
        ModelBlueprint blueprint = MythicUtils.getBlueprintOrNull(modelId);
        if (blueprint == null) {
            return SkillResult.INVALID_CONFIG;
        }
        if (this.map != null) {
            String mapId = MythicUtils.getOrNull(this.map, (PlaceholderMeta)meta, target);
            ModelBlueprint mapBlueprint = MythicUtils.getBlueprintOrNull(mapId);
            if (mapBlueprint == null) {
                return SkillResult.INVALID_CONFIG;
            }
            RendererHandler rendererHandler = activeModel.getRendererHandler();
            Set<String> bones = mapBlueprint.getFlatMap().size() < rendererHandler.getFakeEntity().size() ? mapBlueprint.getFlatMap().keySet() : rendererHandler.getFakeEntity().keySet();
            for (String bone : bones) {
                BoneRenderer renderer;
                Integer data = blueprint.getItemIds().get(bone);
                if (data == null || (renderer = (BoneRenderer)rendererHandler.getFakeEntity().get(bone)) == null) continue;
                renderer.setData(data);
            }
        } else {
            RendererHandler rendererHandler = activeModel.getRendererHandler();
            Set<String> bones = blueprint.getItemIds().size() < rendererHandler.getFakeEntity().size() ? blueprint.getItemIds().keySet() : rendererHandler.getFakeEntity().keySet();
            for (String bone : bones) {
                BoneRenderer renderer;
                Integer data = blueprint.getItemIds().get(bone);
                if (data == null || (renderer = (BoneRenderer)rendererHandler.getFakeEntity().get(bone)) == null) continue;
                renderer.setData(data);
            }
        }
        return SkillResult.SUCCESS;
    }
}

