/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Set;
import org.bukkit.entity.Entity;

public class MechanicMountModel
implements ITargetedEntitySkill {
    private final boolean isDriver;
    private final boolean force;
    private final boolean autoDismount;
    private final boolean canDamageMount;
    private final PlaceholderString mode;
    private PlaceholderString modelId;
    private PlaceholderString pbone;

    public MechanicMountModel(MythicLineConfig mlc) {
        this.isDriver = mlc.getBoolean(new String[]{"d", "drive", "driver"}, true);
        this.force = mlc.getBoolean(new String[]{"f", "force"}, false);
        this.autoDismount = mlc.getBoolean(new String[]{"ad", "autodismount"}, false);
        this.canDamageMount = mlc.getBoolean(new String[]{"dmg", "damagemount"}, false);
        this.mode = mlc.getPlaceholderString(new String[]{"m", "mode"}, "walking", new String[0]);
        if (!this.isDriver) {
            this.modelId = mlc.getPlaceholderString(new String[]{"mid", "model", "modelid"}, null, new String[0]);
            this.pbone = mlc.getPlaceholderString(new String[]{"p", "pbone", "seat"}, null, new String[0]);
        }
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        AbstractEntity caster = meta.getCaster().getEntity();
        ModeledEntity model = ModelEngineAPI.getModeledEntity(caster.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        MountManager handler = model.getMountManager();
        String controller = MythicUtils.getOrNull(this.mode, (PlaceholderMeta)meta, target);
        if (this.isDriver && handler.isCanSteer()) {
            if (this.force) {
                handler.removeDriver();
            } else if (handler.isControlled()) {
                return SkillResult.CONDITION_FAILED;
            }
            if (this.tryDismountOld(target)) {
                handler.setDriver(target.getBukkitEntity(), (MountController)ModelEngineAPI.getControllerRegistry().get(controller));
                handler.setCanDamageMount(target.getUniqueId(), this.canDamageMount);
                return SkillResult.SUCCESS;
            }
            return SkillResult.CONDITION_FAILED;
        }
        if (!this.isDriver && handler.isCanRide()) {
            String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
            if (modelId == null) {
                return SkillResult.INVALID_CONFIG;
            }
            String part = MythicUtils.getOrNull(this.pbone, (PlaceholderMeta)meta, target);
            if (part == null) {
                return SkillResult.INVALID_CONFIG;
            }
            String[] seats = part.split(",");
            if (this.force) {
                String emptiestSeat = null;
                int size = 0;
                for (String seat : seats) {
                    Set<Entity> riders = handler.getPassengersOnSeat(modelId, seat);
                    if (!riders.isEmpty()) {
                        if (emptiestSeat != null && riders.size() >= size) continue;
                        emptiestSeat = seat;
                        size = riders.size();
                        continue;
                    }
                    if (this.tryDismountOld(target)) {
                        handler.addPassengerToSeat(modelId, seat, target.getBukkitEntity(), (MountController)ModelEngineAPI.getControllerRegistry().get(controller));
                        handler.setCanDamageMount(target.getUniqueId(), this.canDamageMount);
                        return SkillResult.SUCCESS;
                    }
                    return SkillResult.CONDITION_FAILED;
                }
                if (this.tryDismountOld(target)) {
                    handler.addPassengerToSeat(modelId, emptiestSeat, target.getBukkitEntity(), (MountController)ModelEngineAPI.getControllerRegistry().get(controller));
                    handler.setCanDamageMount(target.getUniqueId(), this.canDamageMount);
                    return SkillResult.SUCCESS;
                }
                return SkillResult.CONDITION_FAILED;
            }
            for (String seat : seats) {
                Set<Entity> riders = handler.getPassengersOnSeat(modelId, seat);
                if (!riders.isEmpty()) continue;
                if (this.tryDismountOld(target)) {
                    handler.addPassengerToSeat(modelId, seat, target.getBukkitEntity(), (MountController)ModelEngineAPI.getControllerRegistry().get(controller));
                    handler.setCanDamageMount(target.getUniqueId(), this.canDamageMount);
                    return SkillResult.SUCCESS;
                }
                return SkillResult.CONDITION_FAILED;
            }
        }
        return SkillResult.CONDITION_FAILED;
    }

    private boolean tryDismountOld(AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getMountPair(target.getUniqueId());
        if (model == null) {
            return true;
        }
        if (this.autoDismount) {
            model.getMountManager().removeRiders(target.getBukkitEntity());
            return true;
        }
        return false;
    }

    public boolean getTargetsCreatives() {
        return true;
    }
}

