/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.AnimationMode;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.Nameable;
import com.ticxo.modelengine.mythic.MythicUtils;
import com.ticxo.modelengine.mythic.utils.PlaceholderStringInstance;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderStringImpl;

public class MechanicModel
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString mode;
    private final PlaceholderString nametag;
    private final boolean hitbox;
    private final boolean remove;
    private final boolean killOwner;
    private final boolean invisible;
    private final boolean doDamageTint;
    private final boolean canDrive;
    private final boolean canRide;
    private final boolean lockPitch;
    private final boolean lockYaw;
    private final PlaceholderDouble stepHeight;
    private final PlaceholderInt viewRadius;

    public MechanicModel(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.hitbox = mlc.getBoolean(new String[]{"h", "hitbox"}, true);
        this.remove = mlc.getBoolean(new String[]{"r", "remove"}, false);
        this.killOwner = mlc.getBoolean(new String[]{"ko", "killowner"}, false);
        this.invisible = mlc.getBoolean(new String[]{"i", "invis", "invisible"}, true);
        this.doDamageTint = mlc.getBoolean(new String[]{"d", "tint", "damagetint"}, true);
        this.nametag = mlc.getPlaceholderString(new String[]{"n", "name", "nametag"}, null, new String[0]);
        this.canDrive = mlc.getBoolean(new String[]{"drive"}, false);
        this.canRide = mlc.getBoolean(new String[]{"ride"}, false);
        this.mode = mlc.getPlaceholderString(new String[]{"mode"}, null, new String[0]);
        this.lockPitch = mlc.getBoolean(new String[]{"lp", "lpitch", "lockpitch"}, false);
        this.lockYaw = mlc.getBoolean(new String[]{"ly", "lyaw", "lockyaw"}, false);
        this.stepHeight = mlc.getPlaceholderDouble(new String[]{"s", "step"}, 0.5, new String[0]);
        this.viewRadius = mlc.getPlaceholderInteger(new String[]{"rad", "radius"}, 0, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        if (this.remove) {
            return this.removeModel(meta, target);
        }
        return this.addModel(meta, target);
    }

    private SkillResult removeModel(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String id = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        if (id == null) {
            for (ActiveModel activeModel : model.getModels().values()) {
                activeModel.destroy();
            }
        } else {
            ActiveModel activeModel = model.removeModel(id);
            if (activeModel == null) {
                return SkillResult.CONDITION_FAILED;
            }
            activeModel.destroy();
        }
        if (this.killOwner) {
            target.remove();
            return SkillResult.SUCCESS;
        }
        if (model.getModels().isEmpty()) {
            model.setBaseEntityVisible(true);
            ModelEngineAPI.removeModeledEntity(target.getUniqueId());
        } else {
            model.setBaseEntityVisible(!this.invisible);
        }
        return SkillResult.SUCCESS;
    }

    private SkillResult addModel(SkillMetadata meta, AbstractEntity target) {
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        ModelBlueprint blueprint = MythicUtils.getBlueprintOrNull(modelId);
        if (blueprint == null) {
            return SkillResult.INVALID_CONFIG;
        }
        double stepHeight = this.stepHeight.get((PlaceholderMeta)meta, target);
        int viewRadius = this.viewRadius.get((PlaceholderMeta)meta, target);
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            model = ModelEngineAPI.createModeledEntity(target.getBukkitEntity());
        }
        model.setBaseEntityVisible(!this.invisible);
        model.setStepHeight(stepHeight);
        model.getMountManager().setCanSteer(this.canDrive);
        model.getMountManager().setCanRide(this.canRide);
        if (viewRadius > 0) {
            model.getRangeManager().setRenderDistance(viewRadius);
        }
        if (model.getModel(modelId) == null) {
            Nameable nameable;
            ActiveModel activeModel = ModelEngineAPI.createActiveModel(blueprint);
            activeModel.setCanHurt(this.doDamageTint);
            activeModel.setLockPitch(this.lockPitch);
            activeModel.setLockYaw(this.lockYaw);
            String mode = MythicUtils.getOrNull(this.mode, (PlaceholderMeta)meta, target);
            if (mode != null) {
                activeModel.setAnimationMode(AnimationMode.get(mode));
            }
            model.addModel(activeModel, this.hitbox);
            String nametag = MythicUtils.getOrNull(this.nametag, (PlaceholderMeta)meta, target);
            if (nametag != null && (nameable = (Nameable)activeModel.getNametagHandler().getBones().get(nametag)) != null) {
                nameable.setCustomName(new PlaceholderStringInstance((PlaceholderString)new PlaceholderStringImpl("<target.name>"), meta, target));
                nameable.setCustomNameVisible(true);
            }
        }
        return SkillResult.SUCCESS;
    }
}

