/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.Leashable;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicLeashSelf
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString sourceId;
    private final PlaceholderString destId;

    public MechanicLeashSelf(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.sourceId = mlc.getPlaceholderString(new String[]{"s", "sid", "src", "source", "sourceid"}, null, new String[0]);
        this.destId = mlc.getPlaceholderString(new String[]{"d", "did", "dest", "destid"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        AbstractEntity caster = meta.getCaster().getEntity();
        ModeledEntity model = ModelEngineAPI.getModeledEntity(caster.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(model, modelId);
        if (activeModel == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String sourceId = MythicUtils.getOrNull(this.sourceId, (PlaceholderMeta)meta, target);
        if (sourceId == null) {
            return SkillResult.INVALID_CONFIG;
        }
        Leashable sourceBone = (Leashable)activeModel.getLeashHandler().getBones().get(sourceId);
        if (sourceBone == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String destId = MythicUtils.getOrNull(this.destId, (PlaceholderMeta)meta, target);
        if (destId == null) {
            return SkillResult.INVALID_CONFIG;
        }
        Leashable destBone = (Leashable)activeModel.getLeashHandler().getBones().get(destId);
        if (destBone == null) {
            return SkillResult.INVALID_CONFIG;
        }
        sourceBone.setHolder(destBone.getLeashId());
        return SkillResult.SUCCESS;
    }
}

