/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.Leashable;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicLeash
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString sourceId;
    private final boolean flag;

    public MechanicLeash(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.sourceId = mlc.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
        this.flag = mlc.getBoolean(new String[]{"l", "leash"}, true);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        AbstractEntity caster = meta.getCaster().getEntity();
        ModeledEntity model = ModelEngineAPI.getModeledEntity(caster.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(model, modelId);
        if (activeModel == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String sourceId = MythicUtils.getOrNull(this.sourceId, (PlaceholderMeta)meta, target);
        if (sourceId == null) {
            return SkillResult.INVALID_CONFIG;
        }
        Leashable sourceBone = (Leashable)activeModel.getLeashHandler().getBones().get(sourceId);
        if (sourceBone == null) {
            return SkillResult.INVALID_CONFIG;
        }
        sourceBone.setHolder(this.flag ? target.getBukkitEntity().getEntityId() : 0);
        return SkillResult.SUCCESS;
    }
}

