/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Map;

public class MechanicEnchant
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final boolean enchant;
    private final boolean exactMatch;

    public MechanicEnchant(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mlc.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, "", new String[0]);
        this.enchant = mlc.getBoolean(new String[]{"en", "enchant"}, true);
        this.exactMatch = mlc.getBoolean(new String[]{"em", "exact", "match", "exactmatch"}, true);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        String partId = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)meta, target);
        MythicUtils.executeOptModelId(model, modelId, activeModel -> this.enchant((ActiveModel)activeModel, partId));
        return SkillResult.SUCCESS;
    }

    private void enchant(ActiveModel activeModel, String partId) {
        Map renderers = activeModel.getRendererHandler().getFakeEntity();
        if (this.exactMatch) {
            if (renderers.containsKey(partId)) {
                ((BoneRenderer)renderers.get(partId)).setEnchant(this.enchant);
            }
        } else {
            for (String boneId : renderers.keySet()) {
                if (!boneId.contains(partId)) continue;
                ((BoneRenderer)renderers.get(boneId)).setEnchant(this.enchant);
            }
        }
    }
}

