/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicDismountModel
implements ITargetedEntitySkill {
    private final boolean driver;
    private PlaceholderString modelId;
    private PlaceholderString pBone;

    public MechanicDismountModel(MythicLineConfig mlc) {
        this.driver = mlc.getBoolean(new String[]{"d", "drive", "driver"}, true);
        if (!this.driver) {
            this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
            this.pBone = mlc.getPlaceholderString(new String[]{"p", "pbone", "seat"}, null, new String[0]);
        }
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(meta.getCaster().getEntity().getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        MountManager handler = model.getMountManager();
        if (this.driver) {
            handler.removeDriver();
        } else {
            ModelBone bone = handler.getPassengers().get(target.getBukkitEntity());
            if (bone == null) {
                return SkillResult.CONDITION_FAILED;
            }
            String part = MythicUtils.getOrNull(this.pBone, (PlaceholderMeta)meta, target);
            if (part == null) {
                return SkillResult.INVALID_CONFIG;
            }
            String[] seats = part.split(",");
            String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
            if (modelId == null || bone.getActiveModel().getBlueprint().getModelId().equals(modelId)) {
                if (!this.contains(bone.getBoneId(), seats)) {
                    return SkillResult.CONDITION_FAILED;
                }
                handler.removePassenger(target.getBukkitEntity());
            }
        }
        return SkillResult.SUCCESS;
    }

    private boolean contains(String seat, String ... seats) {
        for (String s : seats) {
            if (!seat.equals(s)) continue;
            return true;
        }
        return false;
    }
}

