/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicDismountAll
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString pBone;

    public MechanicDismountAll(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.pBone = mlc.getPlaceholderString(new String[]{"p", "pbone", "seat"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        MountManager handler = model.getMountManager();
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        String parts = MythicUtils.getOrNull(this.pBone, (PlaceholderMeta)meta, target);
        if (modelId != null && parts != null) {
            String[] seats;
            for (String seat : seats = parts.split(",")) {
                handler.clearPassengersOnSeat(modelId, seat);
            }
        } else {
            handler.dismountAllPassengers();
        }
        return SkillResult.SUCCESS;
    }
}

