/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import org.bukkit.entity.Player;

public class MechanicDisguise
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final boolean viewSelf;

    public MechanicDisguise(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.viewSelf = mlc.getBoolean(new String[]{"s", "see", "seeself"}, true);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = (Player)target.getBukkitEntity();
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        ModelBlueprint blueprint = MythicUtils.getBlueprintOrNull(modelId);
        if (blueprint == null) {
            return SkillResult.INVALID_CONFIG;
        }
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(player.getUniqueId());
        if (modeledEntity == null) {
            modeledEntity = ModelEngineAPI.createModeledEntity(player);
            modeledEntity.setBaseEntityVisible(false);
            ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(player, true);
        }
        if (modeledEntity.getModel(modelId) != null) {
            return SkillResult.CONDITION_FAILED;
        }
        RangeManager rangeManager = modeledEntity.getRangeManager();
        if (rangeManager instanceof RangeManager.Disguise) {
            RangeManager.Disguise disguise = (RangeManager.Disguise)((Object)rangeManager);
            disguise.setIncludeSelf(this.viewSelf);
        }
        ActiveModel activeModel = ModelEngineAPI.createActiveModel(blueprint);
        modeledEntity.addModel(activeModel, true);
        return SkillResult.SUCCESS;
    }
}

