/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.AnimationHandler;
import com.ticxo.modelengine.api.animation.state.DefaultStateHandler;
import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicDefaultState
implements ITargetedEntitySkill {
    private final MythicLineConfig config;
    private final PlaceholderString modelId;
    private final PlaceholderString type;
    private ModelState stateType;

    public MechanicDefaultState(MythicLineConfig mlc) {
        this.config = mlc;
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.type = mlc.getPlaceholderString(new String[]{"t", "type"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String type = MythicUtils.getOrNull(this.type, (PlaceholderMeta)meta, target);
        if (type == null) {
            return SkillResult.INVALID_CONFIG;
        }
        this.stateType = ModelState.get(type);
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        MythicUtils.executeOptModelId(model, modelId, activeModel -> this.configureModel((ActiveModel)activeModel, meta, target));
        return SkillResult.SUCCESS;
    }

    private void configureModel(ActiveModel activeModel, SkillMetadata meta, AbstractEntity target) {
        DefaultStateHandler defaultStateHandler = activeModel.getDefaultStateHandler();
        DefaultStateHandler.Property property = defaultStateHandler.getProperty(this.stateType);
        PlaceholderString statePlaceholder = this.config.getPlaceholderString(new String[]{"s", "state"}, property.getAnimation(), new String[0]);
        PlaceholderInt lerpInPlaceholder = this.config.getPlaceholderInteger(new String[]{"li", "lerpin"}, (int)(property.getLerpIn() * 20.0), new String[0]);
        PlaceholderInt lerpOutPlaceholder = this.config.getPlaceholderInteger(new String[]{"lo", "lerpout"}, (int)(property.getLerpOut() * 20.0), new String[0]);
        PlaceholderDouble speedPlaceholder = this.config.getPlaceholderDouble(new String[]{"sp", "speed"}, property.getSpeed(), new String[0]);
        String state = statePlaceholder.get((PlaceholderMeta)meta, target);
        if (!activeModel.getBlueprint().getAnimations().containsKey(state)) {
            return;
        }
        defaultStateHandler.setProperty(this.stateType, new DefaultStateHandler.Property(state, (double)lerpInPlaceholder.get((PlaceholderMeta)meta, target) / 20.0, (double)lerpOutPlaceholder.get((PlaceholderMeta)meta, target) / 20.0, speedPlaceholder.get((PlaceholderMeta)meta, target)));
        AnimationHandler animationHandler = activeModel.getAnimationHandler();
        if (animationHandler.isPlayingAnimation(property.getAnimation())) {
            animationHandler.stopAnimation(property.getAnimation());
            activeModel.playDefaultAnimation(this.stateType);
        }
    }
}

