/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.google.common.collect.Lists;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Arrays;
import java.util.List;

public class MechanicCycleParts
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final PlaceholderString nModelId;
    private final List<String> cycledParts = Lists.newArrayList();
    private final int startingFrame = 0;
    private final int interval;
    private final int duration;

    public MechanicCycleParts(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mlc.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
        this.nModelId = mlc.getPlaceholderString(new String[]{"nm", "nmid", "newmodel", "newmodelid"}, null, new String[0]);
        String nPartId = mlc.getString(new String[]{"np", "npid", "newpart", "newpartid", "newparts", "cycledparts"}, "", new String[0]);
        this.cycledParts.addAll(Arrays.asList(nPartId.split(",")));
        this.interval = mlc.getInteger(new String[]{"interval", "i"}, 1);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, this.cycledParts.size());
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(model, modelId);
        if (activeModel == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String partId = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)meta, target);
        if (partId == null) {
            return SkillResult.INVALID_CONFIG;
        }
        BoneRenderer renderer = (BoneRenderer)activeModel.getRendererHandler().getFakeEntity().get(partId);
        if (renderer == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String nModelId = MythicUtils.getOrNull(this.nModelId, (PlaceholderMeta)meta, target);
        ModelBlueprint blueprint = MythicUtils.getBlueprintOrNull(nModelId);
        if (blueprint == null) {
            return SkillResult.INVALID_CONFIG;
        }
        new Animator(meta, target, activeModel, partId, blueprint);
        return SkillResult.SUCCESS;
    }

    private class Animator
    implements Runnable,
    Terminable {
        private final SkillMetadata data;
        private final AbstractEntity target;
        private final ActiveModel model;
        private final String partId;
        private final ModelBlueprint modelBlueprint;
        private final Task task;
        private int frame = 0;

        public Animator(SkillMetadata data, AbstractEntity target, ActiveModel model, String partId, ModelBlueprint modelBlueprint) {
            this.data = data;
            this.target = target;
            this.model = model;
            this.partId = partId;
            this.modelBlueprint = modelBlueprint;
            this.task = Schedulers.sync().runRepeating((Runnable)this, 0L, (long)MechanicCycleParts.this.interval);
        }

        @Override
        public void run() {
            if (this.target.isDead()) {
                this.terminate();
                return;
            }
            if (this.task.getTimesRan() > MechanicCycleParts.this.duration) {
                this.terminate();
                return;
            }
            BoneRenderer renderer = (BoneRenderer)this.model.getRendererHandler().getFakeEntity().get(this.partId);
            if (renderer == null) {
                this.terminate();
                return;
            }
            String nextPart = MechanicCycleParts.this.cycledParts.get(this.frame);
            Integer data = this.modelBlueprint.getItemIds().get(nextPart);
            if (data == null) {
                this.terminate();
                return;
            }
            renderer.setData(data);
            if (++this.frame > MechanicCycleParts.this.cycledParts.size()) {
                this.frame = 0;
            }
        }

        public void close() throws Exception {
            this.task.terminate();
        }
    }
}

