/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Map;

public class MechanicChangeParent
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString parentPart;
    private final PlaceholderString childPart;

    public MechanicChangeParent(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.parentPart = mlc.getPlaceholderString(new String[]{"p", "parent"}, null, new String[0]);
        this.childPart = mlc.getPlaceholderString(new String[]{"c", "child"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(model, modelId);
        if (activeModel == null) {
            return SkillResult.CONDITION_FAILED;
        }
        Map<String, ModelBone> index = activeModel.getBoneIndex();
        String parentPart = MythicUtils.getOrNull(this.parentPart, (PlaceholderMeta)meta, target);
        if (parentPart == null) {
            return SkillResult.INVALID_CONFIG;
        }
        ModelBone parent = index.get(parentPart);
        if (parent == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String childPart = MythicUtils.getOrNull(this.childPart, (PlaceholderMeta)meta, target);
        if (childPart == null) {
            return SkillResult.INVALID_CONFIG;
        }
        ModelBone child = index.get(childPart);
        if (child == null) {
            return SkillResult.INVALID_CONFIG;
        }
        parent.addChild(child);
        return SkillResult.SUCCESS;
    }
}

