/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import org.bukkit.util.Vector;

public class MechanicBindEntitySubHitbox
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final String strType;
    private MythicMob mm;
    private BukkitEntityType me;

    public MechanicBindEntitySubHitbox(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mlc.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
        this.strType = mlc.getString(new String[]{"type", "t", "mob", "m"}, "SKELETON", new String[0]);
        this.getPlugin().getSkillManager().queueSecondPass(() -> {
            this.mm = this.getPlugin().getMobManager().getMythicMob(this.strType).orElse(null);
            if (this.mm == null) {
                this.me = BukkitEntityType.getMythicEntity((String)this.strType);
                if (this.me == null) {
                    MythicLogger.errorMechanicConfig(null, (MythicLineConfig)mlc, (String)"The 'type' attribute must be a valid MythicMob or MythicEntity type.");
                }
            }
        });
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String modelId = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)meta, target);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(model, modelId);
        if (activeModel == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String partId = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)meta, target);
        if (partId == null) {
            return SkillResult.INVALID_CONFIG;
        }
        SubHitbox subHitbox = (SubHitbox)activeModel.getSubHitboxHandler().getBones().get(partId);
        if (subHitbox == null) {
            return SkillResult.INVALID_CONFIG;
        }
        SkillCaster caster = meta.getCaster();
        AbstractEntity abstractCaster = caster.getEntity();
        AbstractLocation l = BukkitAdapter.adapt((Vector)subHitbox.getPosition()).toLocation(abstractCaster.getWorld());
        AbstractEntity binder = null;
        if (this.mm != null) {
            ActiveMob ams = this.mm.spawn(l, caster.getLevel(), SpawnReason.SUMMON);
            binder = ams.getEntity();
            ams.setParent(caster);
            ams.setOwner(abstractCaster.getUniqueId());
            SkillCaster skillCaster = meta.getCaster();
            if (skillCaster instanceof ActiveMob) {
                ActiveMob am = (ActiveMob)skillCaster;
                ams.setFaction(am.getFaction());
            }
        } else if (this.me != null) {
            binder = this.me.spawn(l, SpawnReason.SUMMON, null);
        }
        if (binder == null || !binder.isLiving()) {
            return SkillResult.CONDITION_FAILED;
        }
        subHitbox.bindEntity(binder.getBukkitEntity());
        return SkillResult.SUCCESS;
    }

    public ThreadSafetyLevel getThreadSafetyLevel() {
        return ThreadSafetyLevel.SYNC_ONLY;
    }
}

