/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.conditions;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import java.util.Set;
import org.bukkit.entity.Entity;

public class ConditionModelHasPassenger
implements IEntityCondition {
    private final PlaceholderString modelId;
    private final PlaceholderString pbone;
    private final String mode;

    public ConditionModelHasPassenger(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.pbone = mlc.getPlaceholderString(new String[]{"p", "pbone, seat"}, null, new String[0]);
        this.mode = mlc.getString(new String[]{"m", "mode"}, "AND", new String[0]);
    }

    public boolean check(AbstractEntity abstractEntity) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (model == null) {
            return false;
        }
        MountManager handler = model.getMountManager();
        if (this.pbone == null) {
            return handler.hasPassengers();
        }
        String[] seats = this.pbone.get(abstractEntity).split(",");
        String modelId = MythicUtils.getOrNull(this.modelId, abstractEntity);
        if (modelId == null) {
            if ("OR".equals(this.mode)) {
                for (String id : model.getModels().keySet()) {
                    for (String seat : seats) {
                        Set<Entity> riders = handler.getPassengersOnSeat(id, seat);
                        if (riders.isEmpty()) continue;
                        return true;
                    }
                }
                return false;
            }
            for (String id : model.getModels().keySet()) {
                for (String seat : seats) {
                    Set<Entity> riders = handler.getPassengersOnSeat(id, seat);
                    if (!riders.isEmpty()) continue;
                    return false;
                }
            }
        } else {
            if ("OR".equals(this.mode)) {
                for (String seat : seats) {
                    Set<Entity> riders = handler.getPassengersOnSeat(modelId, seat);
                    if (riders.isEmpty()) continue;
                    return true;
                }
                return false;
            }
            for (String seat : seats) {
                Set<Entity> riders = handler.getPassengersOnSeat(modelId, seat);
                if (!riders.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }
}

