/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.compatibility;

import com.google.common.collect.ImmutableList;
import com.ticxo.modelengine.ModelEngine;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.model.IModel;
import com.ticxo.modelengine.api.nms.entity.fake.DummyRangeEntity;
import com.ticxo.modelengine.api.nms.entity.hitbox.ModelHitbox;
import com.ticxo.modelengine.api.nms.entity.impl.DefaultBodyRotationController;
import com.ticxo.modelengine.api.nms.entity.impl.EmptyLookController;
import com.ticxo.modelengine.api.nms.entity.impl.EmptyMoveController;
import com.ticxo.modelengine.api.nms.entity.impl.ManualRangeManager;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.nms.entity.wrapper.LookController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.nms.world.IDamageSource;
import com.ticxo.modelengine.api.utils.math.TMath;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;

public class ProjectileEntity
implements BaseEntity<Projectile.ProjectileTracker> {
    private final Projectile.ProjectileTracker original;
    private DummyRangeEntity dummyRange;
    private RangeManager rangeManager;
    private final int entityId;
    private final UUID uniqueId;

    public ProjectileEntity(Projectile.ProjectileTracker original, boolean useDummy) {
        this.original = original;
        if (useDummy) {
            this.dummyRange = ModelEngineAPI.getEntityHandler().createDummyRangeEntity(this);
            this.entityId = this.dummyRange.getBukkit().getEntityId();
            this.uniqueId = this.dummyRange.getBukkit().getUniqueId();
        } else {
            this.entityId = ModelEngineAPI.getEntityHandler().getEntityCounter().incrementAndGet();
            this.uniqueId = UUID.randomUUID();
        }
        ModelEngine.core.getMythicSupport().getTrackers().put(original, this);
    }

    @Override
    public MoveController wrapMoveControl() {
        return new EmptyMoveController();
    }

    @Override
    public LookController wrapLookControl() {
        return new EmptyLookController();
    }

    @Override
    public BodyRotationController wrapBodyRotationControl() {
        return new DefaultBodyRotationController(this);
    }

    @Override
    public void wrapNavigation() {
    }

    @Override
    public RangeManager wrapRangeManager(IModel model) {
        if (this.rangeManager != null) {
            return this.rangeManager;
        }
        this.rangeManager = this.dummyRange == null ? new ManualRangeManager(this, model) : ModelEngineAPI.getEntityHandler().wrapRangeManager(this.dummyRange.getBukkit());
        return this.rangeManager;
    }

    @Override
    public boolean onHurt(IDamageSource damageSource, float damage) {
        return false;
    }

    @Override
    public void onInteract(Player player, EquipmentSlot hand) {
    }

    @Override
    public void setHitbox(Hitbox hitbox) {
    }

    @Override
    public Hitbox getHitbox() {
        return null;
    }

    @Override
    public ModelHitbox getModelHitbox() {
        return null;
    }

    @Override
    public void setStepHeight(double height) {
    }

    @Override
    public Double getStepHeight() {
        return null;
    }

    @Override
    public void setCollidableToLiving(LivingEntity living, boolean flag) {
    }

    @Override
    public void broadcastSpawnPacket() {
    }

    @Override
    public void broadcastDespawnPacket() {
        ModelEngineAPI.getEntityHandler().broadcastDespawnPacket(this, false);
    }

    @Override
    public Location getLocation() {
        return BukkitAdapter.adapt((AbstractLocation)this.original.getCurrentLocation());
    }

    @Override
    public World getWorld() {
        return BukkitAdapter.adapt((AbstractWorld)this.original.getCurrentLocation().getWorld());
    }

    @Override
    public boolean isDead() {
        if (this.original.getCancelled()) {
            ModelEngine.core.getMythicSupport().getTrackers().remove(this.original);
            return true;
        }
        return false;
    }

    @Override
    public boolean isGlowing() {
        return false;
    }

    @Override
    public boolean isOnGround() {
        return false;
    }

    @Override
    public boolean isMoving() {
        return this.original.getCurrentVelocity().lengthSquared() > 1.0E-5;
    }

    @Override
    public void setYHeadRot(float rot) {
    }

    @Override
    public float getYHeadRot() {
        AbstractVector vel = this.original.getCurrentVelocity();
        if (vel == null) {
            return 0.0f;
        }
        return (float)Math.toDegrees(TMath.fastAtan2(-vel.getX(), vel.getZ()));
    }

    @Override
    public float getXHeadRot() {
        AbstractVector vel = this.original.getCurrentVelocity();
        if (vel == null) {
            return 0.0f;
        }
        double hMag = TMath.fastLength(vel.getX(), 0.0, vel.getZ());
        return (float)Math.toDegrees(-TMath.fastAtan2(vel.getY(), hMag));
    }

    @Override
    public void setYBodyRot(float rot) {
    }

    @Override
    public float getYBodyRot() {
        return this.getYHeadRot();
    }

    @Override
    public List<Entity> getPassengers() {
        return ImmutableList.of();
    }

    @Override
    public Projectile.ProjectileTracker getOriginal() {
        return this.original;
    }

    public DummyRangeEntity getDummyRange() {
        return this.dummyRange;
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }
}

