/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.compatibility;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.utils.math.OrientedBoundingBox;
import com.ticxo.modelengine.mythic.compatibility.MEGModel;
import com.ticxo.modelengine.mythic.compatibility.ProjectileEntity;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.compatibility.AbstractModelEngineSupport;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.model.MobModel;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;

public class ModelEngineSupportImpl
extends AbstractModelEngineSupport {
    private final Map<Projectile.ProjectileTracker, ProjectileEntity> trackers = Maps.newConcurrentMap();

    public ModelEngineSupportImpl() {
        super(MythicBukkit.inst());
    }

    public boolean isSubHitbox(UUID uuid) {
        return ModelEngineAPI.getModelTicker().isSubHitbox(uuid);
    }

    public boolean isBoundToSubHitbox(UUID subHitbox, UUID bound) {
        SubHitbox bone = ModelEngineAPI.getModelTicker().getSubHitboxBone(subHitbox);
        return bone != null && bone.getBoundEntities().containsKey(bound);
    }

    public UUID getParentUUID(UUID uuid) {
        SubHitbox sub = ModelEngineAPI.getModelTicker().getSubHitboxBone(uuid);
        if (sub == null) {
            return uuid;
        }
        return sub.getActiveModel().getModeledEntity().getBase().getUniqueId();
    }

    public AbstractEntity getParent(AbstractEntity abstractEntity) {
        SubHitbox sub = ModelEngineAPI.getModelTicker().getSubHitboxBone(abstractEntity.getUniqueId());
        if (sub == null) {
            return abstractEntity;
        }
        BaseEntity<?> base = sub.getActiveModel().getModeledEntity().getBase();
        Object obj = base.getOriginal();
        if (obj instanceof Entity) {
            Entity entity = (Entity)obj;
            return BukkitAdapter.adapt((Entity)entity);
        }
        return abstractEntity;
    }

    public boolean overlapsOOBB(BoundingBox boundingBox, AbstractEntity abstractEntity) {
        UUID uuid = abstractEntity.getUniqueId();
        SubHitbox hitbox = ModelEngineAPI.getModelTicker().getSubHitboxBone(uuid);
        if (hitbox == null) {
            return false;
        }
        OrientedBoundingBox obb = hitbox.getSubHitboxEntity().getObbInstance();
        if (obb == null) {
            return false;
        }
        return obb.intersects(boundingBox);
    }

    public AbstractModelEngineSupport.ModelConfig getBoneModel(String modelId, String boneId) throws IllegalArgumentException {
        ModelBlueprint blueprint = ModelEngineAPI.getBlueprint(modelId);
        if (blueprint == null) {
            throw new IllegalArgumentException("Unknown model " + modelId);
        }
        Integer itemId = blueprint.getItemIds().get(boneId);
        if (itemId == null) {
            throw new IllegalArgumentException("Unknown bone " + boneId);
        }
        BlueprintBone bone = blueprint.getFlatMap().get(boneId);
        return new AbstractModelEngineSupport.ModelConfig(itemId.intValue(), ModelEngineAPI.api.getGenerator().getBaseItemType().getMaterial(), !bone.check("large"));
    }

    public MobModel createMobModel(MythicMob mythicMob, MythicConfig mythicConfig) {
        return new MEGModel(mythicMob, mythicConfig);
    }

    public void queuePostModelRegistration(Runnable runnable) {
    }

    public void load(MythicBukkit mythicBukkit) {
        MythicLogger.log((String)"Model Engine Compatibility Loaded.");
    }

    public void unload() {
    }

    public Map<Projectile.ProjectileTracker, ProjectileEntity> getTrackers() {
        return this.trackers;
    }
}

