/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.compatibility;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.model.MobModel;
import org.bukkit.entity.Entity;

public class MEGModel
extends MobModel {
    private final String id;
    private String mode = "A";
    private String nameplate = "";
    private double stepHeight = 0.5;
    private int viewRadius = 0;
    private boolean useHitbox = true;
    private boolean invisible = true;
    private boolean doDamageTint = true;
    private boolean canDrive = false;
    private boolean canRide = false;
    private boolean lockPitch = false;
    private boolean lockYaw = false;

    public MEGModel(MythicMob baseMob, MythicConfig config) {
        super(baseMob, config);
        if (config.isConfigurationSection("Model")) {
            this.id = config.getString("Model.Id", null);
            this.nameplate = config.getString("Model.Nameplate", null);
            this.stepHeight = config.getDouble("Model.Step", 0.5);
            this.viewRadius = config.getInteger("Model.ViewRadius", 0);
            this.useHitbox = config.getBoolean("Model.Hitbox", true);
            this.invisible = config.getBoolean("Model.Invisible", true);
            this.doDamageTint = config.getBoolean("Model.DamageTint", true);
            this.canDrive = config.getBoolean("Model.Drive", false);
            this.canRide = config.getBoolean("Model.Ride", false);
            this.lockPitch = config.getBoolean("Model.LockPitch", false);
            this.lockYaw = config.getBoolean("Model.LockYaw", false);
        } else {
            this.id = config.getString("Model");
        }
    }

    public void apply(AbstractEntity entity) {
        if (this.id == null) {
            MythicLogger.error((String)"ModelEngine ID not specified");
            return;
        }
        Entity bukkitTarget = BukkitAdapter.adapt((AbstractEntity)entity);
        ModelBlueprint blueprint = ModelEngineAPI.getBlueprint(this.id);
        if (blueprint == null) {
            return;
        }
        ModeledEntity model = ModelEngineAPI.getModeledEntity(bukkitTarget.getUniqueId());
        if (model == null) {
            model = ModelEngineAPI.createModeledEntity(bukkitTarget);
        }
        model.setBaseEntityVisible(!this.invisible);
        model.setStepHeight(this.stepHeight);
        model.getMountManager().setCanSteer(this.canDrive);
        model.getMountManager().setCanRide(this.canRide);
        if (this.viewRadius > 0) {
            model.getRangeManager().setRenderDistance(this.viewRadius);
        }
        if (model.getModel(this.id) == null) {
            ActiveModel activeModel = ModelEngineAPI.createActiveModel(blueprint);
            activeModel.setCanHurt(this.doDamageTint);
            activeModel.setLockPitch(this.lockPitch);
            activeModel.setLockYaw(this.lockYaw);
            model.addModel(activeModel, this.useHitbox);
        }
    }
}

