/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.model.bone;

import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.utils.math.Matrix3x3;
import com.ticxo.modelengine.api.utils.math.Offset;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.model.bone.RendererBone;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class SegmentBone
extends RendererBone {
    private final ModeledEntity model;
    private final Vector axis;
    private final double distance;

    public SegmentBone(@NotNull ActiveModel model, @NotNull BlueprintBone bone) {
        super(model, bone);
        this.model = this.activeModel.getModeledEntity();
        this.axis = bone.getLocalOrigin().clone();
        this.distance = this.axis.length();
        this.axis.normalize().multiply(-1);
    }

    @Override
    public void tick() {
        if (this.position == null) {
            this.position = this.activeModel.getAnimationHandler().getFinalPosition(this);
        }
        Vector target = this.parent == null ? this.model.getLocation() : this.parent.getPosition();
        Vector dir = target.clone().subtract(this.position).normalize();
        Matrix3x3 mat = Matrix3x3.rotationAlign(this.axis, dir);
        this.rotation = mat.toEulerAngle();
        this.clientAproxRotation = this.clientAproxRotation != null ? TMath.slerp(this.clientAproxRotation, this.rotation, calAnimation) : this.rotation;
        Vector offset = Offset.getRelativeLocation(this.rotation, this.axis.clone().multiply(-this.distance));
        this.position = target.clone().add(offset);
    }
}

