/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.model.bone;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.bone.Mountable;
import com.ticxo.modelengine.api.nms.entity.fake.MountPoint;
import com.ticxo.modelengine.model.bone.BasicBone;
import java.util.Arrays;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class MountBone
extends BasicBone
implements Mountable {
    private final MountPoint mountPoint;
    private final boolean isDriverBone;
    private final Set<Entity> riders = Sets.newConcurrentHashSet();

    public MountBone(@NotNull ActiveModel model, @NotNull BlueprintBone bone, boolean isDriver) {
        super(model, bone);
        this.mountPoint = ModelEngineAPI.getEntityHandler().createMountPoint(this);
        this.isDriverBone = isDriver;
        model.getMountHandler().registerSpecialBone(this);
        if (isDriver) {
            model.getModeledEntity().getMountManager().setDriverBone(this);
        }
    }

    @Override
    public void spawn() {
        super.spawn();
        this.mountPoint.initialize();
        this.mountPoint.spawn();
    }

    @Override
    public void destroy() {
        this.clearRiders();
        this.mountPoint.despawn();
        this.activeModel.getMountHandler().unregisterSpecialBone(this.boneId);
        super.destroy();
    }

    @Override
    public void mountRiders(Entity ... entities) {
        this.riders.addAll(Arrays.asList(entities));
        this.mountPoint.addPassengers(entities);
    }

    @Override
    public void dismountRider(Entity entity) {
        this.riders.remove(entity);
        this.mountPoint.removePassengers(entity);
    }

    @Override
    public void clearRiders() {
        this.riders.clear();
        this.mountPoint.clearPassengers();
    }

    @Override
    public Set<Entity> getRiders() {
        return ImmutableSet.copyOf(this.riders);
    }

    @Override
    public MountPoint getMountPoint() {
        return this.mountPoint;
    }

    @Override
    public boolean isDriverBone() {
        return this.isDriverBone;
    }
}

