/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.model.bone;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.AnimationMode;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.math.TMath;
import java.util.Map;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class BasicBone
implements ModelBone {
    protected static boolean useCal;
    protected static double calAnimation;
    protected final String boneId;
    protected String customId;
    protected final ActiveModel activeModel;
    protected final BlueprintBone blueprintBone;
    protected ModelBone parent;
    protected final Map<String, ModelBone> children = Maps.newConcurrentMap();
    protected Vector position;
    protected float yaw;
    protected EulerAngle rotation;
    protected float clientAproxYaw = Float.MAX_VALUE;
    protected EulerAngle clientAproxRotation;
    protected boolean isHead;
    private final AnimationMode mode;
    private float lerpCounter;

    public BasicBone(@NotNull ActiveModel model, @NotNull BlueprintBone bone) {
        this.activeModel = model;
        this.boneId = bone.getName();
        this.blueprintBone = bone;
        this.isHead = this.blueprintBone.check("head");
        this.position = model.getModeledEntity().getLocation().clone().add(this.blueprintBone.getGlobalOrigin());
        this.rotation = this.blueprintBone.getLocalRotation();
        this.mode = this.activeModel.getAnimationMode();
    }

    @Override
    public void tick() {
        switch (this.mode) {
            case A: {
                this.tickA();
                break;
            }
            case B: 
            case C: {
                this.tickBC();
            }
        }
    }

    protected void tickA() {
        float newYaw;
        this.position = this.activeModel.getAnimationHandler().getFinalPosition(this);
        EulerAngle newRotation = this.activeModel.getAnimationHandler().getFinalRotation(this);
        float f = newYaw = this.isHead && !this.activeModel.isLockYaw() ? this.activeModel.getModeledEntity().getHeadYaw() : this.activeModel.getModeledEntity().getBodyYaw();
        if (!this.rotation.equals((Object)newRotation)) {
            this.rotation = newRotation;
            this.lerpCounter = 3.0f;
        }
        if (TMath.rotToByte(this.yaw) != TMath.rotToByte(newYaw)) {
            this.yaw = newYaw;
            this.lerpCounter = 3.0f;
        }
        if (useCal && this.lerpCounter > 0.0f) {
            double lerpRatio = 1.0f / this.lerpCounter;
            this.clientAproxRotation = this.clientAproxRotation != null && !this.blueprintBone.getChildren().isEmpty() ? TMath.slerp(this.clientAproxRotation, this.rotation, lerpRatio) : this.rotation;
            this.clientAproxYaw = this.clientAproxYaw < Float.MAX_VALUE ? TMath.rotLerp(this.clientAproxYaw, this.yaw, lerpRatio) : this.yaw;
            this.lerpCounter -= 1.0f;
        } else {
            this.clientAproxRotation = this.rotation;
            this.clientAproxYaw = this.yaw;
        }
    }

    protected void tickBC() {
        float newYaw;
        this.position = this.activeModel.getAnimationHandler().getFinalPosition(this);
        this.rotation = this.activeModel.getAnimationHandler().getFinalRotation(this);
        float f = newYaw = this.isHead && !this.activeModel.isLockYaw() ? this.activeModel.getModeledEntity().getHeadYaw() : this.activeModel.getModeledEntity().getBodyYaw();
        if (TMath.rotToByte(this.yaw) != TMath.rotToByte(newYaw)) {
            this.yaw = newYaw;
            this.lerpCounter = 3.0f;
        }
        if (useCal && this.lerpCounter > 0.0f) {
            this.clientAproxYaw = this.clientAproxYaw < Float.MAX_VALUE ? TMath.rotLerp(this.clientAproxYaw, this.yaw, (double)(1.0f / this.lerpCounter)) : this.yaw;
            this.lerpCounter -= 1.0f;
        } else {
            this.clientAproxYaw = this.yaw;
        }
        this.clientAproxRotation = this.clientAproxRotation != null && !this.blueprintBone.getChildren().isEmpty() ? TMath.slerp(this.clientAproxRotation, this.rotation, calAnimation) : this.rotation;
    }

    @Override
    public void spawn() {
        this.tick();
        this.children.values().forEach(ModelBone::spawn);
    }

    @Override
    public void destroy() {
        this.children.values().forEach(ModelBone::destroy);
        this.children.clear();
    }

    @Override
    public String getCustomId() {
        return this.customId != null ? this.customId : this.boneId;
    }

    @Override
    public void addChild(ModelBone child) {
        ModelBone parent = child.getParent();
        if (parent != null) {
            parent.removeChild(child.getBoneId());
        }
        child.setParent(this);
        this.children.put(child.getCustomId(), child);
    }

    @Override
    public ModelBone removeChild(String child) {
        return this.children.remove(child);
    }

    @Override
    public void setParent(ModelBone parent) {
        this.parent = parent;
    }

    public static void updateConfigs() {
        useCal = ConfigProperty.USE_CALIBRATION.getBoolean();
        calAnimation = ConfigProperty.CAL_ANIMATION.getDouble();
    }

    @Override
    public String getBoneId() {
        return this.boneId;
    }

    public void setCustomId(String customId) {
        this.customId = customId;
    }

    @Override
    public ActiveModel getActiveModel() {
        return this.activeModel;
    }

    @Override
    public BlueprintBone getBlueprintBone() {
        return this.blueprintBone;
    }

    @Override
    public ModelBone getParent() {
        return this.parent;
    }

    @Override
    public Map<String, ModelBone> getChildren() {
        return this.children;
    }

    @Override
    public Vector getPosition() {
        return this.position;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public EulerAngle getRotation() {
        return this.rotation;
    }

    @Override
    public float getClientAproxYaw() {
        return this.clientAproxYaw;
    }

    @Override
    public EulerAngle getClientAproxRotation() {
        return this.clientAproxRotation;
    }

    @Override
    public boolean isHead() {
        return this.isHead;
    }
}

