/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.model;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.events.AddModelEvent;
import com.ticxo.modelengine.api.events.RemoveModelEvent;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.IModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.api.nms.entity.hitbox.ModelHitbox;
import com.ticxo.modelengine.api.nms.entity.impl.EmptyMoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.nms.entity.wrapper.LookController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.util.Consumer;
import org.bukkit.util.Vector;

@CommandAccessible(value={ModeledEntity.class, IModel.class})
public class ModeledEntityImpl
implements ModeledEntity {
    private final BaseEntity<?> base;
    private final RangeManager rangeManager;
    private final Map<String, ActiveModel> models = Maps.newConcurrentMap();
    private Vector location;
    private final MoveController moveController;
    private final LookController lookController;
    private final BodyRotationController bodyRotationController;
    private final MountManager mountManager;
    private boolean isBaseEntityVisible = true;
    private int hurtTick;
    private float headYaw;
    private float headPitch;
    private float bodyYaw;
    private boolean modelRotationLock = false;
    private ModelState state;
    private boolean isGlowing;
    private final boolean isInitialized;

    public ModeledEntityImpl(BaseEntity<?> entity) {
        this.base = entity;
        ModelEngineAPI.registerModeledEntity(this.base, this);
        this.location = this.base.getLocation().toVector();
        this.rangeManager = this.base.wrapRangeManager(this);
        this.mountManager = new MountManager(this);
        this.moveController = this.base.wrapMoveControl();
        this.lookController = this.base.wrapLookControl();
        this.bodyRotationController = this.base.wrapBodyRotationControl();
        this.base.wrapNavigation();
        this.getRotations();
        this.setState(ModelState.SPAWN);
        this.isInitialized = true;
    }

    @Override
    public boolean tick() {
        if (!this.isInitialized) {
            return true;
        }
        this.location = this.base.getLocation().toVector();
        if (!this.modelRotationLock) {
            this.getRotations();
        }
        this.tickHurt();
        if (this.base.isDead()) {
            this.setState(ModelState.DEATH);
        } else {
            this.manualSetDefaultStates();
        }
        for (ActiveModel model : this.models.values()) {
            if (!model.isGenerated()) continue;
            model.tick();
        }
        this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)ModelHitbox::update));
        this.detectGlowingState();
        return !this.base.isDead() || this.getAnimationState(true);
    }

    @Override
    public void destroy() {
        for (ActiveModel model : this.models.values()) {
            model.destroy();
        }
        this.models.clear();
        this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)ModelHitbox::despawn));
    }

    @Override
    public void setStepHeight(double height) {
        this.base.setStepHeight(height);
    }

    @Override
    public void setRenderRadius(int radius) {
        this.rangeManager.setRenderDistance(radius);
    }

    @Override
    public void setBaseEntityVisible(boolean flag) {
        if (this.isBaseEntityVisible == flag) {
            return;
        }
        this.isBaseEntityVisible = flag;
        if (flag) {
            this.base.broadcastSpawnPacket();
        } else {
            this.base.broadcastDespawnPacket();
        }
    }

    @Override
    public void showToPlayer(Player player) {
        for (ActiveModel model : this.models.values()) {
            model.showToPlayer(player);
        }
        this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)modelHitbox -> modelHitbox.spawn(player)));
    }

    @Override
    public void hideFromPlayer(Player player) {
        for (ActiveModel model : this.models.values()) {
            model.hideFromPlayer(player);
        }
        this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)modelHitbox -> modelHitbox.despawn(player)));
    }

    @Override
    public void hurt() {
        this.hurtTick = 10;
    }

    @Override
    public void addModel(ActiveModel model, boolean overrideHitbox) {
        if (!model.isSwappable()) {
            return;
        }
        try {
            AddModelEvent event = new AddModelEvent(this, model);
            event.setOverrideHitbox(overrideHitbox);
            ModelEngineAPI.callEvent(event);
            if (event.isCancelled()) {
                return;
            }
            model.setSwappable(false);
            model.setModeledEntity(this);
            this.models.put(model.getBlueprint().getModelId(), model);
            model.generateModel();
            model.setGlowing(this.isGlowing);
            if (event.isOverrideHitbox()) {
                this.base.setHitbox(model.getBlueprint().getMainHitbox());
            }
            this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)ModelHitbox::spawn));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public ActiveModel removeModel(String modelId) {
        ActiveModel model = this.models.get(modelId);
        if (model == null) {
            return null;
        }
        RemoveModelEvent event = new RemoveModelEvent(this, model);
        ModelEngineAPI.callEvent(event);
        if (event.isCancelled()) {
            return null;
        }
        return this.models.remove(modelId);
    }

    @Override
    public ActiveModel getModel(String modelId) {
        return this.models.get(modelId);
    }

    @Override
    public boolean getAnimationState(boolean flag) {
        for (ActiveModel model : this.models.values()) {
            if (!model.hasAnimations()) continue;
            return flag;
        }
        return !flag;
    }

    @Override
    public void setState(ModelState state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        for (ActiveModel model : this.models.values()) {
            model.playDefaultAnimation(state);
        }
    }

    private void tickHurt() {
        if (this.hurtTick < 0) {
            return;
        }
        switch (this.hurtTick) {
            case 10: {
                for (ActiveModel model : this.models.values()) {
                    if (!model.isGenerated()) continue;
                    model.setHurt(true);
                }
                break;
            }
            case 0: {
                for (ActiveModel model : this.models.values()) {
                    if (!model.isGenerated()) continue;
                    model.setHurt(false);
                }
                break;
            }
        }
        --this.hurtTick;
    }

    private void detectGlowingState() {
        if (this.isGlowing == this.base.isGlowing()) {
            return;
        }
        this.isGlowing = !this.isGlowing;
        for (ActiveModel model : this.models.values()) {
            if (!model.isGenerated()) continue;
            model.setGlowing(this.isGlowing);
        }
    }

    private void getRotations() {
        this.bodyRotationController.tick();
        this.headYaw = this.bodyRotationController.getYHeadRot();
        this.headPitch = this.bodyRotationController.getXHeadRot();
        this.bodyYaw = this.bodyRotationController.getYBodyRot();
    }

    private void manualSetDefaultStates() {
        MoveController moveController = this.moveController;
        if (moveController instanceof EmptyMoveController) {
            EmptyMoveController controller = (EmptyMoveController)moveController;
            if (this.base.isMoving()) {
                controller.resetIdleDelay();
                this.setState(ModelState.WALK);
            } else {
                this.setState(controller.tickIdleDelay() ? ModelState.IDLE : ModelState.WALK);
            }
        }
    }

    private void updateModelHitbox(Consumer<ModelHitbox> consumer) {
        ModelHitbox hitbox = this.base.getModelHitbox();
        if (hitbox != null) {
            consumer.accept((Object)hitbox);
        }
    }

    @Override
    public BaseEntity<?> getBase() {
        return this.base;
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    @Override
    public Map<String, ActiveModel> getModels() {
        return this.models;
    }

    @Override
    public Vector getLocation() {
        return this.location;
    }

    @Override
    public MoveController getMoveController() {
        return this.moveController;
    }

    @Override
    public LookController getLookController() {
        return this.lookController;
    }

    @Override
    public BodyRotationController getBodyRotationController() {
        return this.bodyRotationController;
    }

    @Override
    public MountManager getMountManager() {
        return this.mountManager;
    }

    @Override
    public boolean isBaseEntityVisible() {
        return this.isBaseEntityVisible;
    }

    @Override
    public float getHeadYaw() {
        return this.headYaw;
    }

    @Override
    public float getHeadPitch() {
        return this.headPitch;
    }

    @Override
    public float getBodyYaw() {
        return this.bodyYaw;
    }

    @Override
    public boolean isModelRotationLock() {
        return this.modelRotationLock;
    }

    @Override
    public void setModelRotationLock(boolean modelRotationLock) {
        this.modelRotationLock = modelRotationLock;
    }

    @Override
    public ModelState getState() {
        return this.state;
    }
}

